/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.reader.FileRecordFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.FSDataInputStream;

class TestIntReader
implements StreamFormat.Reader<Integer>,
FileRecordFormat.Reader<Integer> {
    private static final int SKIPS_PER_OFFSET = 7;
    private final FSDataInputStream in;
    private final DataInputStream din;
    private final long endOffset;
    private long currentOffset;
    private long currentSkipCount;
    private final boolean checkpointed;

    TestIntReader(FSDataInputStream in, long endOffset, boolean checkpointsPosition) throws IOException {
        this.in = in;
        this.endOffset = endOffset;
        this.currentOffset = in.getPos();
        this.din = new DataInputStream((InputStream)in);
        this.checkpointed = checkpointsPosition;
    }

    @Nullable
    public Integer read() throws IOException {
        if (this.in.getPos() >= this.endOffset) {
            return null;
        }
        try {
            int next = this.din.readInt();
            this.incrementPosition();
            return next;
        }
        catch (EOFException e) {
            return null;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    @Nullable
    public CheckpointedPosition getCheckpointedPosition() {
        return this.checkpointed ? new CheckpointedPosition(this.currentOffset, this.currentSkipCount) : null;
    }

    private void incrementPosition() {
        ++this.currentSkipCount;
        if (this.currentSkipCount >= 7L) {
            this.currentOffset += 4L * this.currentSkipCount;
            this.currentSkipCount = 0L;
        }
    }
}

