/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.util.Optional;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitState;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileSourceSplitStateTest {
    FileSourceSplitStateTest() {
    }

    @Test
    void testRoundTripWithoutModification() {
        FileSourceSplit split = FileSourceSplitStateTest.getTestSplit();
        FileSourceSplitState state = new FileSourceSplitState(split);
        FileSourceSplit resultSplit = state.toFileSourceSplit();
        Assertions.assertThat((Optional)resultSplit.getReaderPosition()).isEqualTo((Object)split.getReaderPosition());
    }

    @Test
    void testStateStartsWithSplitValues() {
        FileSourceSplit split = FileSourceSplitStateTest.getTestSplit(new CheckpointedPosition(123L, 456L));
        FileSourceSplitState state = new FileSourceSplitState(split);
        Assertions.assertThat((long)state.getOffset()).isEqualTo(123L);
        Assertions.assertThat((long)state.getRecordsToSkipAfterOffset()).isEqualTo(456L);
    }

    @Test
    void testNewSplitTakesModifiedOffsetAndCount() {
        FileSourceSplit split = FileSourceSplitStateTest.getTestSplit();
        FileSourceSplitState state = new FileSourceSplitState(split);
        state.setPosition(1234L, 7566L);
        Optional position = state.toFileSourceSplit().getReaderPosition();
        Assertions.assertThat((Optional)position).isPresent();
        Assertions.assertThat(position.get()).isEqualTo((Object)new CheckpointedPosition(1234L, 7566L));
    }

    private static FileSourceSplit getTestSplit() {
        return FileSourceSplitStateTest.getTestSplit(null);
    }

    private static FileSourceSplit getTestSplit(CheckpointedPosition position) {
        return new FileSourceSplit("test-id", new Path("file:/some/random/path"), 17L, 121L, 0L, 150L, new String[]{"localhost"}, position);
    }
}

