/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitSerializer;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileSourceSplitSerializerTest {
    FileSourceSplitSerializerTest() {
    }

    @Test
    void serializeSplitWithHosts() throws Exception {
        FileSourceSplit split = new FileSourceSplit("random-id", new Path("hdfs://namenode:14565/some/path/to/a/file"), 100000000L, 64000000L, System.currentTimeMillis(), 200000000L, new String[]{"host1", "host2", "host3"});
        FileSourceSplit deSerialized = FileSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    @Test
    void serializeSplitWithoutHosts() throws Exception {
        FileSourceSplit split = new FileSourceSplit("some-id", new Path("file:/some/path/to/a/file"), 0L, 0L, System.currentTimeMillis(), 200000000L);
        FileSourceSplit deSerialized = FileSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    @Test
    void serializeSplitWithReaderPosition() throws Exception {
        FileSourceSplit split = new FileSourceSplit("random-id", new Path("hdfs://namenode:14565/some/path/to/a/file"), 100000000L, 64000000L, System.currentTimeMillis(), 200000000L, new String[]{"host1", "host2", "host3"}, new CheckpointedPosition(7665391L, 100L));
        FileSourceSplit deSerialized = FileSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    @Test
    void repeatedSerialization() throws Exception {
        FileSourceSplit split = new FileSourceSplit("an-id", new Path("s3://some-bucket/key/to/the/object"), 0L, 1234567L, System.currentTimeMillis(), 200000000L);
        FileSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileSourceSplit deSerialized = FileSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    @Test
    void repeatedSerializationCaches() throws Exception {
        FileSourceSplit split = new FileSourceSplit("random-id", new Path("hdfs://namenode:14565/some/path/to/a/file"), 100000000L, 64000000L, System.currentTimeMillis(), 200000000L, new String[]{"host1", "host2", "host3"});
        byte[] ser1 = FileSourceSplitSerializer.INSTANCE.serialize(split);
        byte[] ser2 = FileSourceSplitSerializer.INSTANCE.serialize(split);
        Assertions.assertThat((byte[])ser1).isSameAs((Object)ser2);
    }

    private static FileSourceSplit serializeAndDeserialize(FileSourceSplit split) throws IOException {
        FileSourceSplitSerializer serializer = new FileSourceSplitSerializer();
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)serializer, (Object)split);
        return (FileSourceSplit)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)serializer, (byte[])bytes);
    }

    static void assertSplitsEqual(FileSourceSplit expected, FileSourceSplit actual) {
        Assertions.assertThat((String)actual.splitId()).isEqualTo(expected.splitId());
        Assertions.assertThat((Object)actual.path()).isEqualTo((Object)expected.path());
        Assertions.assertThat((long)actual.offset()).isEqualTo(expected.offset());
        Assertions.assertThat((long)actual.length()).isEqualTo(expected.length());
        Assertions.assertThat((Object[])actual.hostnames()).isEqualTo((Object)expected.hostnames());
        Assertions.assertThat((Optional)actual.getReaderPosition()).isEqualTo((Object)expected.getReaderPosition());
    }
}

