/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.time.ZoneId;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch7Configuration;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch7DynamicSink;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch7DynamicSource;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchValidationUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.StringUtils;

@Internal
public class Elasticsearch7DynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final Set<ConfigOption<?>> requiredOptions = Stream.of(ElasticsearchConnectorOptions.HOSTS_OPTION, ElasticsearchConnectorOptions.INDEX_OPTION).collect(Collectors.toSet());
    private static final Set<ConfigOption<?>> optionalOptions = Stream.of(ElasticsearchConnectorOptions.KEY_DELIMITER_OPTION, ElasticsearchConnectorOptions.FAILURE_HANDLER_OPTION, ElasticsearchConnectorOptions.FLUSH_ON_CHECKPOINT_OPTION, ElasticsearchConnectorOptions.BULK_FLASH_MAX_SIZE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_INTERVAL_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION, ElasticsearchConnectorOptions.CONNECTION_PATH_PREFIX, ElasticsearchConnectorOptions.FORMAT_OPTION, ElasticsearchConnectorOptions.PASSWORD_OPTION, ElasticsearchConnectorOptions.USERNAME_OPTION, LookupOptions.CACHE_TYPE, LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS, LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE, LookupOptions.PARTIAL_CACHE_MAX_ROWS, LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY, LookupOptions.MAX_RETRIES).collect(Collectors.toSet());

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        DataType physicalRowDataType = context.getPhysicalRowDataType();
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig options = helper.getOptions();
        DecodingFormat format = helper.discoverDecodingFormat(DeserializationFormatFactory.class, org.apache.flink.connector.elasticsearch.table.ElasticsearchConnectorOptions.FORMAT_OPTION);
        helper.validate();
        Configuration configuration = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)configuration).setString(arg_0, arg_1));
        Elasticsearch7Configuration config = new Elasticsearch7Configuration((ReadableConfig)configuration, context.getClassLoader());
        return new Elasticsearch7DynamicSource((DecodingFormat<DeserializationSchema<RowData>>)format, config, physicalRowDataType, (Integer)options.get(LookupOptions.MAX_RETRIES), this.getLookupCache(options));
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        ElasticsearchValidationUtils.validatePrimaryKey((TableSchema)tableSchema);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, ElasticsearchConnectorOptions.FORMAT_OPTION);
        helper.validate();
        Configuration configuration = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)configuration).setString(arg_0, arg_1));
        Elasticsearch7Configuration config = new Elasticsearch7Configuration((ReadableConfig)configuration, context.getClassLoader());
        this.validate(config, configuration);
        return new Elasticsearch7DynamicSink((EncodingFormat<SerializationSchema<RowData>>)format, config, TableSchemaUtils.getPhysicalSchema((TableSchema)tableSchema), this.getLocalTimeZoneId(context.getConfiguration()));
    }

    @Nullable
    private LookupCache getLookupCache(ReadableConfig tableOptions) {
        DefaultLookupCache cache = null;
        if (((LookupOptions.LookupCacheType)tableOptions.get(LookupOptions.CACHE_TYPE)).equals((Object)LookupOptions.LookupCacheType.PARTIAL)) {
            cache = DefaultLookupCache.fromConfig((ReadableConfig)tableOptions);
        }
        return cache;
    }

    ZoneId getLocalTimeZoneId(ReadableConfig readableConfig) {
        String zone = (String)readableConfig.get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        return zoneId;
    }

    private void validate(Elasticsearch7Configuration config, Configuration originalConfiguration) {
        config.getFailureHandler();
        config.getHosts();
        Elasticsearch7DynamicTableFactory.validate(config.getIndex().length() >= 1, () -> String.format("'%s' must not be empty", ElasticsearchConnectorOptions.INDEX_OPTION.key()));
        int maxActions = config.getBulkFlushMaxActions();
        Elasticsearch7DynamicTableFactory.validate(maxActions == -1 || maxActions >= 1, () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION.key(), maxActions));
        long maxSize = config.getBulkFlushMaxByteSize();
        long mb1 = 0x100000L;
        Elasticsearch7DynamicTableFactory.validate(maxSize == -1L || maxSize >= mb1 && maxSize % mb1 == 0L, () -> String.format("'%s' must be in MB granularity. Got: %s", ElasticsearchConnectorOptions.BULK_FLASH_MAX_SIZE_OPTION.key(), ((MemorySize)originalConfiguration.get(ElasticsearchConnectorOptions.BULK_FLASH_MAX_SIZE_OPTION)).toHumanReadableString()));
        Elasticsearch7DynamicTableFactory.validate(config.getBulkFlushBackoffRetries().map(retries -> retries >= 1).orElse(true), () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION.key(), config.getBulkFlushBackoffRetries().get()));
        if (config.getUsername().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)((String)config.getUsername().get()))) {
            Elasticsearch7DynamicTableFactory.validate(config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)((String)config.getPassword().get())), () -> String.format("'%s' and '%s' must be set at the same time. Got: username '%s' and password '%s'", ElasticsearchConnectorOptions.USERNAME_OPTION.key(), ElasticsearchConnectorOptions.PASSWORD_OPTION.key(), config.getUsername().get(), config.getPassword().orElse("")));
        }
    }

    private static void validate(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new ValidationException(message.get());
        }
    }

    public String factoryIdentifier() {
        return "elasticsearch-7";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return optionalOptions;
    }
}

