/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchApiCallBridge;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch7Configuration;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch7DynamicSink;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchRowDataLookupFunction;
import org.apache.flink.streaming.connectors.elasticsearch7.Elasticsearch7ApiCallBridge;
import org.apache.flink.streaming.connectors.elasticsearch7.RestClientFactory;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class Elasticsearch7DynamicSource
implements LookupTableSource,
SupportsProjectionPushDown {
    private final DecodingFormat<DeserializationSchema<RowData>> format;
    private final Elasticsearch7Configuration config;
    private final int lookupMaxRetryTimes;
    private final LookupCache lookupCache;
    private DataType physicalRowDataType;

    public Elasticsearch7DynamicSource(DecodingFormat<DeserializationSchema<RowData>> format, Elasticsearch7Configuration config, DataType physicalRowDataType, int lookupMaxRetryTimes, @Nullable LookupCache lookupCache) {
        this.format = format;
        this.config = config;
        this.physicalRowDataType = physicalRowDataType;
        this.lookupMaxRetryTimes = lookupMaxRetryTimes;
        this.lookupCache = lookupCache;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        RestClientFactory restClientFactory = null;
        restClientFactory = this.config.getUsername().isPresent() && this.config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)((String)this.config.getUsername().get())) && !StringUtils.isNullOrWhitespaceOnly((String)((String)this.config.getPassword().get())) ? new Elasticsearch7DynamicSink.AuthRestClientFactory(this.config.getPathPrefix().orElse(null), (String)this.config.getUsername().get(), (String)this.config.getPassword().get()) : new Elasticsearch7DynamicSink.DefaultRestClientFactory(this.config.getPathPrefix().orElse(null));
        Elasticsearch7ApiCallBridge elasticsearch7ApiCallBridge = new Elasticsearch7ApiCallBridge(this.config.getHosts(), restClientFactory);
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"Elasticsearch only support non-nested look up keys");
            keyNames[i] = (String)DataType.getFieldNames((DataType)this.physicalRowDataType).get(innerKeyArr[0]);
        }
        ElasticsearchRowDataLookupFunction lookupFunction = new ElasticsearchRowDataLookupFunction((DeserializationSchema)this.format.createRuntimeDecoder((DynamicTableSource.Context)context, this.physicalRowDataType), this.lookupMaxRetryTimes, this.config.getIndex(), this.config.getDocumentType(), DataType.getFieldNames((DataType)this.physicalRowDataType).toArray(new String[0]), DataType.getFieldDataTypes((DataType)this.physicalRowDataType).toArray(new DataType[0]), keyNames, (ElasticsearchApiCallBridge)elasticsearch7ApiCallBridge);
        if (this.lookupCache != null) {
            return PartialCachingLookupProvider.of((LookupFunction)lookupFunction, (LookupCache)this.lookupCache);
        }
        return LookupFunctionProvider.of((LookupFunction)lookupFunction);
    }

    public DynamicTableSource copy() {
        return new Elasticsearch7DynamicSource(this.format, this.config, this.physicalRowDataType, this.lookupMaxRetryTimes, this.lookupCache);
    }

    public String asSummaryString() {
        return "Elasticsearch7";
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType type) {
        this.physicalRowDataType = Projection.of((int[][])projectedFields).project(type);
    }
}

