/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch6;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchApiCallBridge;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.apache.flink.streaming.connectors.elasticsearch6.Elasticsearch6BulkProcessorIndexer;
import org.apache.flink.streaming.connectors.elasticsearch6.RestClientFactory;
import org.apache.flink.util.Preconditions;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class Elasticsearch6ApiCallBridge
implements ElasticsearchApiCallBridge<RestHighLevelClient> {
    private static final long serialVersionUID = -5222683870097809633L;
    private static final Logger LOG = LoggerFactory.getLogger(Elasticsearch6ApiCallBridge.class);
    private final List<HttpHost> httpHosts;
    private final RestClientFactory restClientFactory;

    Elasticsearch6ApiCallBridge(List<HttpHost> httpHosts, RestClientFactory restClientFactory) {
        Preconditions.checkArgument((httpHosts != null && !httpHosts.isEmpty() ? 1 : 0) != 0);
        this.httpHosts = httpHosts;
        this.restClientFactory = (RestClientFactory)Preconditions.checkNotNull((Object)restClientFactory);
    }

    public RestHighLevelClient createClient() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.httpHosts.toArray(new HttpHost[this.httpHosts.size()]));
        this.restClientFactory.configureRestClientBuilder(builder);
        RestHighLevelClient rhlClient = new RestHighLevelClient(builder);
        return rhlClient;
    }

    public BulkProcessor.Builder createBulkProcessorBuilder(RestHighLevelClient client, BulkProcessor.Listener listener) {
        return BulkProcessor.builder((x$0, x$1) -> client.bulkAsync(x$0, x$1, new Header[0]), (BulkProcessor.Listener)listener);
    }

    public Throwable extractFailureCauseFromBulkItemResponse(BulkItemResponse bulkItemResponse) {
        if (!bulkItemResponse.isFailed()) {
            return null;
        }
        return bulkItemResponse.getFailure().getCause();
    }

    public void configureBulkProcessorFlushInterval(BulkProcessor.Builder builder, long flushIntervalMillis) {
        builder.setFlushInterval(TimeValue.timeValueMillis((long)flushIntervalMillis));
    }

    public void configureBulkProcessorBackoff(BulkProcessor.Builder builder, @Nullable ElasticsearchSinkBase.BulkFlushBackoffPolicy flushBackoffPolicy) {
        BackoffPolicy backoffPolicy;
        if (flushBackoffPolicy != null) {
            switch (flushBackoffPolicy.getBackoffType()) {
                case CONSTANT: {
                    backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)new TimeValue(flushBackoffPolicy.getDelayMillis()), (int)flushBackoffPolicy.getMaxRetryCount());
                    break;
                }
                default: {
                    backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)new TimeValue(flushBackoffPolicy.getDelayMillis()), (int)flushBackoffPolicy.getMaxRetryCount());
                    break;
                }
            }
        } else {
            backoffPolicy = BackoffPolicy.noBackoff();
        }
        builder.setBackoffPolicy(backoffPolicy);
    }

    public RequestIndexer createBulkProcessorIndexer(BulkProcessor bulkProcessor, boolean flushOnCheckpoint, AtomicLong numPendingRequestsRef) {
        return new Elasticsearch6BulkProcessorIndexer(bulkProcessor, flushOnCheckpoint, numPendingRequestsRef);
    }

    public void verifyClientConnection(RestHighLevelClient client) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Pinging Elasticsearch cluster via hosts {} ...", this.httpHosts);
        }
        if (!client.ping(new Header[0])) {
            throw new RuntimeException("There are no reachable Elasticsearch nodes!");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Elasticsearch RestHighLevelClient is connected to {}", (Object)this.httpHosts.toString());
        }
    }
}

