/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.time.ZoneId;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch6Configuration;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch6DynamicSink;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchValidationUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.StringUtils;

@Internal
public class Elasticsearch6DynamicSinkFactory
implements DynamicTableSinkFactory {
    private static final Set<ConfigOption<?>> requiredOptions = Stream.of(ElasticsearchConnectorOptions.HOSTS_OPTION, ElasticsearchConnectorOptions.INDEX_OPTION, ElasticsearchConnectorOptions.DOCUMENT_TYPE_OPTION).collect(Collectors.toSet());
    private static final Set<ConfigOption<?>> optionalOptions = Stream.of(ElasticsearchConnectorOptions.KEY_DELIMITER_OPTION, ElasticsearchConnectorOptions.FAILURE_HANDLER_OPTION, ElasticsearchConnectorOptions.FLUSH_ON_CHECKPOINT_OPTION, ElasticsearchConnectorOptions.BULK_FLASH_MAX_SIZE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_INTERVAL_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION, ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION, ElasticsearchConnectorOptions.CONNECTION_PATH_PREFIX, ElasticsearchConnectorOptions.FORMAT_OPTION, ElasticsearchConnectorOptions.PASSWORD_OPTION, ElasticsearchConnectorOptions.USERNAME_OPTION).collect(Collectors.toSet());

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        ElasticsearchValidationUtils.validatePrimaryKey((TableSchema)tableSchema);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, ElasticsearchConnectorOptions.FORMAT_OPTION);
        helper.validate();
        Configuration configuration = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)configuration).setString(arg_0, arg_1));
        Elasticsearch6Configuration config = new Elasticsearch6Configuration((ReadableConfig)configuration, context.getClassLoader());
        this.validate(config, configuration);
        return new Elasticsearch6DynamicSink((EncodingFormat<SerializationSchema<RowData>>)format, config, TableSchemaUtils.getPhysicalSchema((TableSchema)tableSchema), this.getLocalTimeZoneId(context.getConfiguration()));
    }

    ZoneId getLocalTimeZoneId(ReadableConfig readableConfig) {
        String zone = (String)readableConfig.get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        return zoneId;
    }

    private void validate(Elasticsearch6Configuration config, Configuration originalConfiguration) {
        config.getFailureHandler();
        config.getHosts();
        Elasticsearch6DynamicSinkFactory.validate(config.getIndex().length() >= 1, () -> String.format("'%s' must not be empty", ElasticsearchConnectorOptions.INDEX_OPTION.key()));
        int maxActions = config.getBulkFlushMaxActions();
        Elasticsearch6DynamicSinkFactory.validate(maxActions == -1 || maxActions >= 1, () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION.key(), maxActions));
        long maxSize = config.getBulkFlushMaxByteSize();
        long mb1 = 0x100000L;
        Elasticsearch6DynamicSinkFactory.validate(maxSize == -1L || maxSize >= mb1 && maxSize % mb1 == 0L, () -> String.format("'%s' must be in MB granularity. Got: %s", ElasticsearchConnectorOptions.BULK_FLASH_MAX_SIZE_OPTION.key(), ((MemorySize)originalConfiguration.get(ElasticsearchConnectorOptions.BULK_FLASH_MAX_SIZE_OPTION)).toHumanReadableString()));
        Elasticsearch6DynamicSinkFactory.validate(config.getBulkFlushBackoffRetries().map(retries -> retries >= 1).orElse(true), () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION.key(), config.getBulkFlushBackoffRetries().get()));
        if (config.getUsername().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)((String)config.getUsername().get()))) {
            Elasticsearch6DynamicSinkFactory.validate(config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)((String)config.getPassword().get())), () -> String.format("'%s' and '%s' must be set at the same time. Got: username '%s' and password '%s'", ElasticsearchConnectorOptions.USERNAME_OPTION.key(), ElasticsearchConnectorOptions.PASSWORD_OPTION.key(), config.getUsername().get(), config.getPassword().orElse("")));
        }
    }

    private static void validate(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new ValidationException(message.get());
        }
    }

    public String factoryIdentifier() {
        return "elasticsearch-6";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return optionalOptions;
    }
}

