/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.util.function.BiConsumer;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorBuilderFactory;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorConfig;
import org.apache.flink.connector.elasticsearch.sink.BulkRequestConsumerFactory;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchSinkBuilderBase;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

@PublicEvolving
public class Elasticsearch6SinkBuilder<IN>
extends ElasticsearchSinkBuilderBase<IN, Elasticsearch6SinkBuilder<IN>> {
    public <T extends IN> Elasticsearch6SinkBuilder<T> setEmitter(ElasticsearchEmitter<? super T> emitter) {
        super.setEmitter(emitter);
        return (Elasticsearch6SinkBuilder)this.self();
    }

    protected BulkProcessorBuilderFactory getBulkProcessorBuilderFactory() {
        return new BulkProcessorBuilderFactory(){

            public BulkProcessor.Builder apply(final RestHighLevelClient client, BulkProcessorConfig bulkProcessorConfig, BulkProcessor.Listener listener) {
                BackoffPolicy backoffPolicy;
                BulkProcessor.Builder builder = BulkProcessor.builder((BiConsumer)new BulkRequestConsumerFactory(){

                    public void accept(BulkRequest bulkRequest, ActionListener<BulkResponse> bulkResponseActionListener) {
                        client.bulkAsync(bulkRequest, bulkResponseActionListener, new Header[0]);
                    }
                }, (BulkProcessor.Listener)listener);
                if (bulkProcessorConfig.getBulkFlushMaxActions() != -1) {
                    builder.setBulkActions(bulkProcessorConfig.getBulkFlushMaxActions());
                }
                if (bulkProcessorConfig.getBulkFlushMaxMb() != -1) {
                    builder.setBulkSize(new ByteSizeValue((long)bulkProcessorConfig.getBulkFlushMaxMb(), ByteSizeUnit.MB));
                }
                if (bulkProcessorConfig.getBulkFlushInterval() != -1L) {
                    builder.setFlushInterval(new TimeValue(bulkProcessorConfig.getBulkFlushInterval()));
                }
                TimeValue backoffDelay = new TimeValue(bulkProcessorConfig.getBulkFlushBackOffDelay());
                int maxRetryCount = bulkProcessorConfig.getBulkFlushBackoffRetries();
                switch (bulkProcessorConfig.getFlushBackoffType()) {
                    case CONSTANT: {
                        backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)backoffDelay, (int)maxRetryCount);
                        break;
                    }
                    case EXPONENTIAL: {
                        backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)backoffDelay, (int)maxRetryCount);
                        break;
                    }
                    case NONE: {
                        backoffPolicy = BackoffPolicy.noBackoff();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Received unknown backoff policy type " + bulkProcessorConfig.getFlushBackoffType());
                    }
                }
                builder.setBackoffPolicy(backoffPolicy);
                return builder;
            }
        };
    }
}

