/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.util;

import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.http.HttpHost;

public class ElasticsearchCommonUtils {
    public static HttpHost validateAndParseHostsString(String host) {
        try {
            HttpHost httpHost = HttpHost.create((String)host);
            if (httpHost.getPort() < 0) {
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'. Missing port.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()));
            }
            if (httpHost.getSchemeName() == null) {
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'. Missing scheme.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()));
            }
            return httpHost;
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()), (Throwable)e);
        }
    }
}

