/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkBase;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.search.SearchRequest;

@Internal
public interface ElasticsearchApiCallBridge<C extends AutoCloseable>
extends Serializable {
    public C createClient();

    public BulkProcessor.Builder createBulkProcessorBuilder(C var1, BulkProcessor.Listener var2);

    public Tuple2<String, String[]> search(C var1, SearchRequest var2) throws IOException;

    public void close(C var1) throws IOException;

    @Nullable
    public Throwable extractFailureCauseFromBulkItemResponse(BulkItemResponse var1);

    public void configureBulkProcessorFlushInterval(BulkProcessor.Builder var1, long var2);

    public void configureBulkProcessorBackoff(BulkProcessor.Builder var1, @Nullable ElasticsearchSinkBase.BulkFlushBackoffPolicy var2);

    public void verifyClientConnection(C var1) throws IOException;

    public RequestIndexer createBulkProcessorIndexer(BulkProcessor var1, boolean var2, AtomicLong var3);

    default public void cleanup() {
    }
}

