/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorBuilderFactory;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorConfig;
import org.apache.flink.connector.elasticsearch.sink.BulkResponseInspector;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchWriter;
import org.apache.flink.connector.elasticsearch.sink.NetworkClientConfig;
import org.apache.flink.util.Preconditions;
import org.apache.http.HttpHost;

@PublicEvolving
public class ElasticsearchSink<IN>
implements Sink<IN> {
    private final List<HttpHost> hosts;
    private final ElasticsearchEmitter<? super IN> emitter;
    private final BulkProcessorConfig buildBulkProcessorConfig;
    private final BulkProcessorBuilderFactory bulkProcessorBuilderFactory;
    private final BulkResponseInspector.BulkResponseInspectorFactory bulkResponseInspectorFactory;
    private final NetworkClientConfig networkClientConfig;
    private final DeliveryGuarantee deliveryGuarantee;

    ElasticsearchSink(List<HttpHost> hosts, ElasticsearchEmitter<? super IN> emitter, DeliveryGuarantee deliveryGuarantee, BulkProcessorBuilderFactory bulkProcessorBuilderFactory, BulkProcessorConfig buildBulkProcessorConfig, NetworkClientConfig networkClientConfig, BulkResponseInspector.BulkResponseInspectorFactory bulkResponseInspectorFactory) {
        this.hosts = (List)Preconditions.checkNotNull(hosts);
        this.bulkProcessorBuilderFactory = (BulkProcessorBuilderFactory)Preconditions.checkNotNull((Object)bulkProcessorBuilderFactory);
        this.bulkResponseInspectorFactory = (BulkResponseInspector.BulkResponseInspectorFactory)Preconditions.checkNotNull((Object)bulkResponseInspectorFactory);
        Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"Hosts cannot be empty.");
        this.emitter = (ElasticsearchEmitter)Preconditions.checkNotNull(emitter);
        this.deliveryGuarantee = (DeliveryGuarantee)Preconditions.checkNotNull((Object)deliveryGuarantee);
        this.buildBulkProcessorConfig = (BulkProcessorConfig)Preconditions.checkNotNull((Object)buildBulkProcessorConfig);
        this.networkClientConfig = (NetworkClientConfig)Preconditions.checkNotNull((Object)networkClientConfig);
    }

    public SinkWriter<IN> createWriter(Sink.InitContext context) throws IOException {
        return new ElasticsearchWriter<IN>(this.hosts, this.emitter, this.deliveryGuarantee == DeliveryGuarantee.AT_LEAST_ONCE, this.buildBulkProcessorConfig, this.bulkProcessorBuilderFactory, (BulkResponseInspector)this.bulkResponseInspectorFactory.apply(() -> ((Sink.InitContext)context).metricGroup()), this.networkClientConfig, context.metricGroup(), context.getMailboxExecutor());
    }

    @VisibleForTesting
    DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    @VisibleForTesting
    BulkResponseInspector.BulkResponseInspectorFactory getBulkResponseInspectorFactory() {
        return this.bulkResponseInspectorFactory;
    }

    @VisibleForTesting
    NetworkClientConfig getNetworkClientConfig() {
        return this.networkClientConfig;
    }
}

