/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.dynamodb.sink.InvalidConfigurationException;
import org.apache.flink.connector.dynamodb.sink.InvalidRequestException;
import org.apache.flink.util.CollectionUtil;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@Internal
public class PrimaryKeyBuilder {
    private static final String DELIMITER = "$";
    private final List<String> partitionKeys;

    public PrimaryKeyBuilder(List<String> partitionKeys) {
        if (CollectionUtil.isNullOrEmpty(partitionKeys)) {
            throw new InvalidConfigurationException("Unable to construct partition key as overwriteByPartitionKeys configuration not provided.");
        }
        this.partitionKeys = partitionKeys;
    }

    public String build(WriteRequest request) {
        Map<String, AttributeValue> requestItems = PrimaryKeyBuilder.getRequestItems(request);
        StringBuilder builder = new StringBuilder();
        for (String keyName : this.partitionKeys) {
            AttributeValue keyAttribute = requestItems.get(keyName);
            if (keyAttribute == null) {
                throw new InvalidRequestException("Request " + request + " does not contain partition key " + keyName + ".");
            }
            String keyValue = PrimaryKeyBuilder.getKeyValue(keyAttribute);
            if (StringUtils.isBlank((CharSequence)keyValue)) {
                throw new InvalidRequestException("Partition key or sort key attributes require non-empty values. Request " + request + " contains empty key " + keyName + ".");
            }
            builder.append(keyValue).append(DELIMITER);
        }
        return builder.toString();
    }

    private static String getKeyValue(AttributeValue value) {
        StringBuilder builder = new StringBuilder();
        if (value.n() != null) {
            builder.append(value.n());
        }
        if (value.s() != null) {
            builder.append(value.s());
        }
        if (value.b() != null) {
            builder.append(value.b().asUtf8String());
        }
        return builder.toString();
    }

    private static Map<String, AttributeValue> getRequestItems(WriteRequest request) {
        if (request.putRequest() != null) {
            if (request.putRequest().hasItem()) {
                return request.putRequest().item();
            }
            throw new InvalidRequestException("PutItemRequest " + request + " does not contain request items.");
        }
        if (request.deleteRequest() != null) {
            if (request.deleteRequest().hasKey()) {
                return request.deleteRequest().key();
            }
            throw new InvalidRequestException("DeleteItemRequest " + request + " does not contain request key.");
        }
        throw new InvalidRequestException("Empty write request " + request);
    }
}

