/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.connector.dynamodb.sink.DynamoDbSink;
import org.apache.flink.connector.dynamodb.sink.DynamoDbSinkBuilder;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequest;
import org.apache.flink.connector.dynamodb.table.RowDataElementConverter;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;

@Internal
public class DynamoDbDynamicSink
extends AsyncDynamicTableSink<DynamoDbWriteRequest>
implements SupportsPartitioning {
    private final String tableName;
    private final boolean failOnError;
    private final Properties dynamoDbClientProperties;
    private final DataType physicalDataType;
    private final Set<String> overwriteByPartitionKeys;

    protected DynamoDbDynamicSink(@Nullable Integer maxBatchSize, @Nullable Integer maxInFlightRequests, @Nullable Integer maxBufferedRequests, @Nullable Long maxBufferSizeInBytes, @Nullable Long maxTimeInBufferMS, String tableName, boolean failOnError, Properties dynamoDbClientProperties, DataType physicalDataType, Set<String> overwriteByPartitionKeys) {
        super(maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBufferSizeInBytes, maxTimeInBufferMS);
        this.tableName = tableName;
        this.failOnError = failOnError;
        this.dynamoDbClientProperties = dynamoDbClientProperties;
        this.physicalDataType = physicalDataType;
        this.overwriteByPartitionKeys = overwriteByPartitionKeys;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        return ChangelogMode.upsert();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        DynamoDbSinkBuilder<RowData> builder = DynamoDbSink.builder().setTableName(this.tableName).setFailOnError(this.failOnError).setOverwriteByPartitionKeys(new ArrayList<String>(this.overwriteByPartitionKeys)).setDynamoDbProperties(this.dynamoDbClientProperties).setElementConverter(new RowDataElementConverter(this.physicalDataType));
        this.addAsyncOptionsToSinkBuilder(builder);
        return SinkV2Provider.of((Sink)builder.build());
    }

    public DynamicTableSink copy() {
        return new DynamoDbDynamicSink(this.maxBatchSize, this.maxInFlightRequests, this.maxBufferedRequests, this.maxBufferSizeInBytes, this.maxTimeInBufferMS, this.tableName, this.failOnError, this.dynamoDbClientProperties, this.physicalDataType, this.overwriteByPartitionKeys);
    }

    public String asSummaryString() {
        return "DynamoDB";
    }

    public void applyStaticPartition(Map<String, String> partitions) {
    }

    public static DynamoDbDynamicTableSinkBuilder builder() {
        return new DynamoDbDynamicTableSinkBuilder();
    }

    @Internal
    public static class DynamoDbDynamicTableSinkBuilder
    extends AsyncDynamicTableSinkBuilder<DynamoDbWriteRequest, DynamoDbDynamicTableSinkBuilder> {
        private String tableName;
        private boolean failOnError;
        private Properties dynamoDbClientProperties;
        private DataType physicalDataType;
        private Set<String> overwriteByPartitionKeys;

        public DynamoDbDynamicTableSinkBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DynamoDbDynamicTableSinkBuilder setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public DynamoDbDynamicTableSinkBuilder setDynamoDbClientProperties(Properties dynamoDbClientProperties) {
            this.dynamoDbClientProperties = dynamoDbClientProperties;
            return this;
        }

        public DynamoDbDynamicTableSinkBuilder setPhysicalDataType(DataType physicalDataType) {
            this.physicalDataType = physicalDataType;
            return this;
        }

        public DynamoDbDynamicTableSinkBuilder setOverwriteByPartitionKeys(Set<String> overwriteByPartitionKeys) {
            this.overwriteByPartitionKeys = overwriteByPartitionKeys;
            return this;
        }

        public AsyncDynamicTableSink<DynamoDbWriteRequest> build() {
            return new DynamoDbDynamicSink(this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBufferSizeInBytes(), this.getMaxTimeInBufferMS(), this.tableName, this.failOnError, this.dynamoDbClientProperties, this.physicalDataType, this.overwriteByPartitionKeys);
        }
    }
}

