/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table;

import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.aws.table.util.AsyncClientOptionsUtils;
import org.apache.flink.connector.base.table.sink.options.AsyncSinkConfigurationValidator;
import org.apache.flink.connector.dynamodb.table.DynamoDbConnectorOptions;

@Internal
public class DynamoDbConfiguration {
    private final Map<String, String> rawTableOptions;
    private final ReadableConfig tableOptions;
    private final AsyncSinkConfigurationValidator asyncSinkConfigurationValidator;
    private final AsyncClientOptionsUtils asyncClientOptionsUtils;

    public DynamoDbConfiguration(Map<String, String> rawTableOptions, ReadableConfig tableOptions) {
        this.rawTableOptions = rawTableOptions;
        this.tableOptions = tableOptions;
        this.asyncSinkConfigurationValidator = new AsyncSinkConfigurationValidator(tableOptions);
        this.asyncClientOptionsUtils = new AsyncClientOptionsUtils(rawTableOptions);
    }

    public String getTableName() {
        return (String)this.tableOptions.get(DynamoDbConnectorOptions.TABLE_NAME);
    }

    public boolean getFailOnError() {
        return (Boolean)this.tableOptions.get(DynamoDbConnectorOptions.FAIL_ON_ERROR);
    }

    public Properties getAsyncSinkProperties() {
        return this.asyncSinkConfigurationValidator.getValidatedConfigurations();
    }

    public Properties getSinkClientProperties() {
        return this.asyncClientOptionsUtils.getValidatedConfigurations();
    }
}

