/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.sink.client;

import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.aws.util.AWSClientUtil;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.connector.dynamodb.sink.client.SdkClientProvider;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Internal
public class DynamoDbAsyncClientProvider
implements SdkClientProvider<DynamoDbAsyncClient> {
    private final SdkAsyncHttpClient httpClient;
    private final DynamoDbAsyncClient dynamoDbAsyncClient;

    public DynamoDbAsyncClientProvider(Properties clientProperties) {
        this.httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)this.overrideClientProperties(clientProperties));
        this.dynamoDbAsyncClient = this.buildClient(clientProperties, this.httpClient);
    }

    @Override
    public DynamoDbAsyncClient getClient() {
        return this.dynamoDbAsyncClient;
    }

    public void close() {
        AWSGeneralUtil.closeResources((SdkAutoCloseable[])new SdkAutoCloseable[]{this.httpClient, this.dynamoDbAsyncClient});
    }

    private Properties overrideClientProperties(Properties dynamoDbClientProperties) {
        Properties overridenProperties = new Properties();
        overridenProperties.putAll((Map<?, ?>)dynamoDbClientProperties);
        overridenProperties.putIfAbsent("aws.http.protocol.version", "HTTP1_1");
        return overridenProperties;
    }

    private DynamoDbAsyncClient buildClient(Properties dynamoDbClientProperties, SdkAsyncHttpClient httpClient) {
        AWSGeneralUtil.validateAwsCredentials((Properties)dynamoDbClientProperties);
        return (DynamoDbAsyncClient)AWSClientUtil.createAwsAsyncClient((Properties)dynamoDbClientProperties, (SdkAsyncHttpClient)httpClient, (AwsAsyncClientBuilder)DynamoDbAsyncClient.builder(), (String)"Apache Flink %s (%s) DynamoDb Connector", (String)"aws.dynamodb.client.user-agent-prefix");
    }
}

