/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.sink;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequestType;
import org.apache.flink.util.Preconditions;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@PublicEvolving
public class DynamoDbWriteRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> item;
    private final DynamoDbWriteRequestType type;

    private DynamoDbWriteRequest(Map<String, AttributeValue> item, DynamoDbWriteRequestType type) {
        this.item = item;
        this.type = type;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public DynamoDbWriteRequestType getType() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "DynamoDbWriteRequest{item=" + this.item + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static class Builder {
        private Map<String, AttributeValue> item;
        private DynamoDbWriteRequestType type;

        public Builder setItem(Map<String, AttributeValue> item) {
            this.item = item;
            return this;
        }

        public Builder setType(DynamoDbWriteRequestType type) {
            this.type = type;
            return this;
        }

        public DynamoDbWriteRequest build() {
            Preconditions.checkNotNull(this.item, (String)"No Item was supplied to the DynamoDbWriteRequest builder.");
            Preconditions.checkNotNull((Object)((Object)this.type), (String)"No type was supplied to the DynamoDbWriteRequest builder.");
            return new DynamoDbWriteRequest(this.item, this.type);
        }
    }
}

