/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.AsyncSinkBaseBuilder;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.dynamodb.sink.DynamoDbSink;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequest;
import org.apache.flink.connector.dynamodb.sink.InvalidConfigurationException;

@PublicEvolving
public class DynamoDbSinkBuilder<InputT>
extends AsyncSinkBaseBuilder<InputT, DynamoDbWriteRequest, DynamoDbSinkBuilder<InputT>> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 25;
    private static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS = 50;
    private static final int DEFAULT_MAX_BUFFERED_REQUESTS = 10000;
    private static final long DEFAULT_MAX_RECORD_SIZE_IN_B = 400000L;
    private static final long DEFAULT_MAX_BATCH_SIZE_IN_B = 16000000L;
    private static final long DEFAULT_MAX_TIME_IN_BUFFER_MS = 5000L;
    private static final boolean DEFAULT_FAIL_ON_ERROR = false;
    private boolean failOnError;
    private Properties dynamodbClientProperties;
    private ElementConverter<InputT, DynamoDbWriteRequest> elementConverter;
    private String tableName;
    private List<String> overwriteByPartitionKeys;

    public DynamoDbSinkBuilder<InputT> setDynamoDbProperties(Properties properties) {
        this.dynamodbClientProperties = properties;
        return this;
    }

    public DynamoDbSinkBuilder<InputT> setElementConverter(ElementConverter<InputT, DynamoDbWriteRequest> elementConverter) {
        this.elementConverter = elementConverter;
        return this;
    }

    public DynamoDbSinkBuilder<InputT> setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public DynamoDbSinkBuilder<InputT> setOverwriteByPartitionKeys(List<String> overwriteByPartitionKeys) {
        this.overwriteByPartitionKeys = overwriteByPartitionKeys;
        return this;
    }

    public DynamoDbSinkBuilder<InputT> setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public DynamoDbSinkBuilder<InputT> setMaxBatchSizeInBytes(long maxBatchSizeInBytes) {
        throw new InvalidConfigurationException("Max batch size in bytes is not supported by the DynamoDB sink implementation.");
    }

    public DynamoDbSinkBuilder<InputT> setMaxRecordSizeInBytes(long maxRecordSizeInBytes) {
        throw new InvalidConfigurationException("Max record size in bytes is not supported by the DynamoDB sink implementation.");
    }

    public DynamoDbSink<InputT> build() {
        return new DynamoDbSink<InputT>(this.elementConverter, Optional.ofNullable(this.getMaxBatchSize()).orElse(25), Optional.ofNullable(this.getMaxInFlightRequests()).orElse(50), Optional.ofNullable(this.getMaxBufferedRequests()).orElse(10000), Optional.ofNullable(this.getMaxBatchSizeInBytes()).orElse(16000000L), Optional.ofNullable(this.getMaxTimeInBufferMS()).orElse(5000L), Optional.ofNullable(this.getMaxRecordSizeInBytes()).orElse(400000L), Optional.of(this.failOnError).orElse(false), this.tableName, Optional.ofNullable(this.overwriteByPartitionKeys).orElse(new ArrayList()), Optional.ofNullable(this.dynamodbClientProperties).orElse(new Properties()));
    }
}

