/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.util;

import org.apache.flink.annotation.Internal;

@Internal
public enum DynamoDbType {
    STRING(0),
    NUMBER(1),
    BOOLEAN(2),
    NULL(3),
    BINARY(4),
    STRING_SET(5),
    NUMBER_SET(6),
    BINARY_SET(7),
    LIST(8),
    MAP(9);

    private final byte value;

    private DynamoDbType(byte value) {
        this.value = value;
    }

    public byte toByteValue() {
        return this.value;
    }

    public static DynamoDbType fromByteValue(byte value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return NUMBER;
            }
            case 2: {
                return BOOLEAN;
            }
            case 3: {
                return NULL;
            }
            case 4: {
                return BINARY;
            }
            case 5: {
                return STRING_SET;
            }
            case 6: {
                return NUMBER_SET;
            }
            case 7: {
                return BINARY_SET;
            }
            case 8: {
                return LIST;
            }
            case 9: {
                return MAP;
            }
        }
        throw new UnsupportedOperationException("Unsupported byte value '" + value + "' for DynamoDb type.");
    }
}

