/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequest;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequestType;
import org.apache.flink.connector.dynamodb.util.DynamoDbType;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Internal
public class DynamoDbSerializationUtil {
    public static void serializeWriteRequest(DynamoDbWriteRequest dynamoDbWriteRequest, DataOutputStream out) throws IOException {
        out.writeByte(dynamoDbWriteRequest.getType().toByteValue());
        Map<String, AttributeValue> item = dynamoDbWriteRequest.getItem();
        DynamoDbSerializationUtil.serializeItem(item, out);
    }

    public static DynamoDbWriteRequest deserializeWriteRequest(DataInputStream in) throws IOException {
        int writeRequestType = in.read();
        DynamoDbWriteRequestType dynamoDbWriteRequestType = DynamoDbWriteRequestType.fromByteValue((byte)writeRequestType);
        Map<String, AttributeValue> item = DynamoDbSerializationUtil.deserializeItem(in);
        return DynamoDbWriteRequest.builder().setType(dynamoDbWriteRequestType).setItem(item).build();
    }

    private static void serializeItem(Map<String, AttributeValue> item, DataOutputStream out) throws IOException {
        out.writeInt(item.size());
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            out.writeUTF(entry.getKey());
            AttributeValue value = entry.getValue();
            DynamoDbSerializationUtil.serializeAttributeValue(value, out);
        }
    }

    private static void serializeAttributeValue(AttributeValue value, DataOutputStream out) throws IOException {
        if (value.nul() != null) {
            out.writeByte(DynamoDbType.NULL.toByteValue());
        } else if (value.bool() != null) {
            out.writeByte(DynamoDbType.BOOLEAN.toByteValue());
            out.writeBoolean(value.bool());
        } else if (value.s() != null) {
            out.writeByte(DynamoDbType.STRING.toByteValue());
            out.writeUTF(value.s());
        } else if (value.n() != null) {
            out.writeByte(DynamoDbType.NUMBER.toByteValue());
            out.writeUTF(value.n());
        } else if (value.b() != null) {
            byte[] bytes = value.b().asByteArrayUnsafe();
            out.writeByte(DynamoDbType.BINARY.toByteValue());
            out.writeInt(bytes.length);
            out.write(bytes);
        } else if (value.hasSs()) {
            out.writeByte(DynamoDbType.STRING_SET.toByteValue());
            out.writeInt(value.ss().size());
            for (String s : value.ss()) {
                out.writeUTF(s);
            }
        } else if (value.hasNs()) {
            out.writeByte(DynamoDbType.NUMBER_SET.toByteValue());
            out.writeInt(value.ns().size());
            for (String s : value.ns()) {
                out.writeUTF(s);
            }
        } else if (value.hasBs()) {
            out.writeByte(DynamoDbType.BINARY_SET.toByteValue());
            out.writeInt(value.bs().size());
            for (SdkBytes sdkBytes : value.bs()) {
                byte[] bytes = sdkBytes.asByteArrayUnsafe();
                out.writeInt(bytes.length);
                out.write(bytes);
            }
        } else if (value.hasL()) {
            out.writeByte(DynamoDbType.LIST.toByteValue());
            List l = value.l();
            out.writeInt(l.size());
            for (AttributeValue attributeValue : l) {
                DynamoDbSerializationUtil.serializeAttributeValue(attributeValue, out);
            }
        } else if (value.hasM()) {
            out.writeByte(DynamoDbType.MAP.toByteValue());
            Map m = value.m();
            DynamoDbSerializationUtil.serializeItem(m, out);
        } else {
            throw new IllegalArgumentException("Attribute value must not be empty: " + value);
        }
    }

    private static Map<String, AttributeValue> deserializeItem(DataInputStream in) throws IOException {
        int size = in.readInt();
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            AttributeValue attributeValue = DynamoDbSerializationUtil.deserializeAttributeValue(in);
            item.put(key, attributeValue);
        }
        return item;
    }

    private static AttributeValue deserializeAttributeValue(DataInputStream in) throws IOException {
        int type = in.read();
        DynamoDbType dynamoDbType = DynamoDbType.fromByteValue((byte)type);
        return DynamoDbSerializationUtil.deserializeAttributeValue(dynamoDbType, in);
    }

    private static AttributeValue deserializeAttributeValue(DynamoDbType dynamoDbType, DataInputStream in) throws IOException {
        switch (dynamoDbType) {
            case NULL: {
                return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
            }
            case STRING: {
                return (AttributeValue)AttributeValue.builder().s(in.readUTF()).build();
            }
            case NUMBER: {
                return (AttributeValue)AttributeValue.builder().n(in.readUTF()).build();
            }
            case BOOLEAN: {
                return (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(in.readBoolean())).build();
            }
            case BINARY: {
                int length = in.readInt();
                byte[] bytes = new byte[length];
                in.read(bytes);
                return (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])bytes)).build();
            }
            case STRING_SET: {
                int stringSetSize = in.readInt();
                ArrayList<String> stringSet = new ArrayList<String>(stringSetSize);
                for (int i = 0; i < stringSetSize; ++i) {
                    stringSet.add(in.readUTF());
                }
                return (AttributeValue)AttributeValue.builder().ss(stringSet).build();
            }
            case NUMBER_SET: {
                int numberSetSize = in.readInt();
                ArrayList<String> numberSet = new ArrayList<String>(numberSetSize);
                for (int i = 0; i < numberSetSize; ++i) {
                    numberSet.add(in.readUTF());
                }
                return (AttributeValue)AttributeValue.builder().ns(numberSet).build();
            }
            case BINARY_SET: {
                int binarySetSize = in.readInt();
                ArrayList<SdkBytes> byteSet = new ArrayList<SdkBytes>(binarySetSize);
                for (int i = 0; i < binarySetSize; ++i) {
                    int byteLength = in.readInt();
                    byte[] bs = new byte[byteLength];
                    in.read(bs);
                    byteSet.add(SdkBytes.fromByteArray((byte[])bs));
                }
                return (AttributeValue)AttributeValue.builder().bs(byteSet).build();
            }
            case LIST: {
                int listSize = in.readInt();
                ArrayList<AttributeValue> list = new ArrayList<AttributeValue>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    list.add(DynamoDbSerializationUtil.deserializeAttributeValue(in));
                }
                return (AttributeValue)AttributeValue.builder().l(list).build();
            }
            case MAP: {
                return (AttributeValue)AttributeValue.builder().m(DynamoDbSerializationUtil.deserializeItem(in)).build();
            }
        }
        throw new IllegalArgumentException("Unknown DynamoDbType " + (Object)((Object)dynamoDbType));
    }
}

