/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table.converter;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.dynamodb.table.converter.ArrayAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;

@Internal
public class ArrayAttributeConverterProvider
implements AttributeConverterProvider {
    private static final AttributeConverterProvider defaultAttributeConverterProvider = AttributeConverterProvider.defaultProvider();

    public <T> AttributeConverter<T> converterFor(EnhancedType<T> enhancedType) {
        if (enhancedType.equals((Object)EnhancedType.of(String[].class))) {
            return this.getArrayAttributeConverter(String.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Boolean[].class))) {
            return this.getArrayAttributeConverter(Boolean.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(BigDecimal[].class))) {
            return this.getArrayAttributeConverter(BigDecimal.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Byte[].class))) {
            return this.getArrayAttributeConverter(Byte.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Double[].class))) {
            return this.getArrayAttributeConverter(Double.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Short[].class))) {
            return this.getArrayAttributeConverter(Short.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Integer[].class))) {
            return this.getArrayAttributeConverter(Integer.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Long[].class))) {
            return this.getArrayAttributeConverter(Long.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Float[].class))) {
            return this.getArrayAttributeConverter(Float.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(LocalDate[].class))) {
            return this.getArrayAttributeConverter(LocalDate.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(LocalTime[].class))) {
            return this.getArrayAttributeConverter(LocalTime.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(LocalDateTime[].class))) {
            return this.getArrayAttributeConverter(LocalDateTime.class, enhancedType);
        }
        if (enhancedType.equals((Object)EnhancedType.of(Instant[].class))) {
            return this.getArrayAttributeConverter(Instant.class, enhancedType);
        }
        return null;
    }

    private <R, T> ArrayAttributeConverter<R> getArrayAttributeConverter(Class<R> clazz, EnhancedType<T> enhancedType) {
        return new ArrayAttributeConverter(defaultAttributeConverterProvider.converterFor(EnhancedType.of(clazz)), enhancedType);
    }
}

