/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table.converter;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Internal
public class ArrayAttributeConverter<T>
implements AttributeConverter<T[]> {
    private final AttributeConverter<T> tAttributeConverter;
    private final EnhancedType<T[]> enhancedType;

    public ArrayAttributeConverter(AttributeConverter<T> tAttributeConverter, EnhancedType<T[]> enhancedType) {
        this.tAttributeConverter = tAttributeConverter;
        this.enhancedType = enhancedType;
    }

    public AttributeValue transformFrom(T[] input) {
        return (AttributeValue)AttributeValue.builder().l((Collection)Arrays.stream(input).map(arg_0 -> this.tAttributeConverter.transformFrom(arg_0)).collect(Collectors.toList())).build();
    }

    public T[] transformTo(AttributeValue input) {
        throw new UnsupportedOperationException("transformTo() is unsupported because the DynamoDB sink does not need it.");
    }

    public EnhancedType<T[]> type() {
        return this.enhancedType;
    }

    public AttributeValueType attributeValueType() {
        return AttributeValueType.L;
    }
}

