/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.dynamodb.table.converter.ArrayAttributeConverterProvider;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.LogicalType;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableSchema;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Internal
public class RowDataToAttributeValueConverter {
    private final DataType physicalDataType;
    private final TableSchema<RowData> tableSchema;

    public RowDataToAttributeValueConverter(DataType physicalDataType) {
        this.physicalDataType = physicalDataType;
        this.tableSchema = this.createTableSchema();
    }

    public Map<String, AttributeValue> convertRowData(RowData row) {
        return this.tableSchema.itemToMap((Object)row, false);
    }

    private StaticTableSchema<RowData> createTableSchema() {
        List fields = DataType.getFields((DataType)this.physicalDataType);
        StaticTableSchema.Builder<RowData> builder = TableSchema.builder(RowData.class);
        ArrayAttributeConverterProvider newAttributeConverterProvider = new ArrayAttributeConverterProvider();
        builder.attributeConverterProviders(new AttributeConverterProvider[]{newAttributeConverterProvider, AttributeConverterProvider.defaultProvider()});
        for (int i = 0; i < fields.size(); ++i) {
            DataTypes.Field field = (DataTypes.Field)fields.get(i);
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)field.getDataType().getLogicalType(), (int)i);
            builder = this.addAttribute(builder, field, fieldGetter);
        }
        return builder.build();
    }

    private StaticTableSchema.Builder<RowData> addAttribute(StaticTableSchema.Builder<RowData> builder, DataTypes.Field field, RowData.FieldGetter fieldGetter) {
        return builder.addAttribute(this.getEnhancedType(field.getDataType()), a -> a.name(field.getName()).getter(rowData -> DataStructureConverters.getConverter((DataType)field.getDataType()).toExternal(fieldGetter.getFieldOrNull(rowData))).setter((rowData, t) -> {}));
    }

    private <T> EnhancedType<T> getEnhancedType(DataType dataType) {
        if (dataType instanceof KeyValueDataType) {
            return EnhancedType.mapOf(this.getEnhancedType(((KeyValueDataType)dataType).getKeyDataType()), this.getEnhancedType(((KeyValueDataType)dataType).getValueDataType()));
        }
        return EnhancedType.of((Class)dataType.getConversionClass());
    }
}

