/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequest;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequestType;
import org.apache.flink.connector.dynamodb.table.RowDataToAttributeValueConverter;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;

@Internal
public class RowDataElementConverter
implements ElementConverter<RowData, DynamoDbWriteRequest> {
    private final DataType physicalDataType;
    private transient RowDataToAttributeValueConverter rowDataToAttributeValueConverter;

    public RowDataElementConverter(DataType physicalDataType) {
        this.physicalDataType = physicalDataType;
        this.rowDataToAttributeValueConverter = new RowDataToAttributeValueConverter(physicalDataType);
    }

    public DynamoDbWriteRequest apply(RowData element, SinkWriter.Context context) {
        if (this.rowDataToAttributeValueConverter == null) {
            this.rowDataToAttributeValueConverter = new RowDataToAttributeValueConverter(this.physicalDataType);
        }
        DynamoDbWriteRequest.Builder builder = DynamoDbWriteRequest.builder().setItem(this.rowDataToAttributeValueConverter.convertRowData(element));
        switch (element.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                builder.setType(DynamoDbWriteRequestType.PUT);
                break;
            }
            case DELETE: {
                builder.setType(DynamoDbWriteRequestType.DELETE);
                break;
            }
            default: {
                throw new TableException("Unsupported message kind: " + element.getRowKind());
            }
        }
        return builder.build();
    }
}

