/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.table;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.table.AsyncDynamicTableSinkFactory;
import org.apache.flink.connector.dynamodb.table.DynamoDbConfiguration;
import org.apache.flink.connector.dynamodb.table.DynamoDbConnectorOptions;
import org.apache.flink.connector.dynamodb.table.DynamoDbDynamicSink;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;

@Internal
public class DynamoDbDynamicSinkFactory
extends AsyncDynamicTableSinkFactory {
    public static final String FACTORY_IDENTIFIER = "dynamodb";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper factoryHelper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ResolvedCatalogTable catalogTable = context.getCatalogTable();
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)factoryHelper.getOptions());
        DynamoDbConfiguration dynamoDbConfiguration = new DynamoDbConfiguration(catalogTable.getOptions(), factoryHelper.getOptions());
        DynamoDbDynamicSink.DynamoDbDynamicTableSinkBuilder builder = DynamoDbDynamicSink.builder().setTableName(dynamoDbConfiguration.getTableName()).setFailOnError(dynamoDbConfiguration.getFailOnError()).setPhysicalDataType(catalogTable.getResolvedSchema().toPhysicalRowDataType()).setOverwriteByPartitionKeys(new HashSet<String>(catalogTable.getPartitionKeys())).setDynamoDbClientProperties(dynamoDbConfiguration.getSinkClientProperties());
        this.addAsyncOptionsToBuilder(dynamoDbConfiguration.getAsyncSinkProperties(), builder);
        return builder.build();
    }

    public String factoryIdentifier() {
        return FACTORY_IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return ImmutableSet.of(DynamoDbConnectorOptions.TABLE_NAME, DynamoDbConnectorOptions.AWS_REGION);
    }
}

