/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.dynamodb.sink.DynamoDbSinkBuilder;
import org.apache.flink.connector.dynamodb.sink.DynamoDbSinkWriter;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequest;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriterStateSerializer;
import org.apache.flink.connector.dynamodb.sink.client.DynamoDbAsyncClientProvider;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class DynamoDbSink<InputT>
extends AsyncSinkBase<InputT, DynamoDbWriteRequest> {
    private final Properties dynamoDbClientProperties;
    private final boolean failOnError;
    private final String tableName;
    private final List<String> overwriteByPartitionKeys;

    protected DynamoDbSink(ElementConverter<InputT, DynamoDbWriteRequest> elementConverter, int maxBatchSize, int maxInFlightRequests, int maxBufferedRequests, long maxBatchSizeInBytes, long maxTimeInBufferMS, long maxRecordSizeInBytes, boolean failOnError, String tableName, List<String> overwriteByPartitionKeys, Properties dynamoDbClientProperties) {
        super(elementConverter, maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBatchSizeInBytes, maxTimeInBufferMS, maxRecordSizeInBytes);
        Preconditions.checkNotNull((Object)tableName, (String)"Destination table name must be set when initializing the DynamoDB Sink.");
        Preconditions.checkArgument((!tableName.isEmpty() ? 1 : 0) != 0, (Object)"Destination table name must be set when initializing the DynamoDB Sink.");
        Preconditions.checkArgument((maxBatchSize <= 25 ? 1 : 0) != 0, (Object)"DynamoDB client supports only up to 25 elements in the batch.");
        Preconditions.checkNotNull((Object)dynamoDbClientProperties, (String)"DynamoDB client properties must be set.");
        this.failOnError = failOnError;
        this.tableName = tableName;
        this.overwriteByPartitionKeys = overwriteByPartitionKeys;
        this.dynamoDbClientProperties = dynamoDbClientProperties;
    }

    public static <InputT> DynamoDbSinkBuilder<InputT> builder() {
        return new DynamoDbSinkBuilder();
    }

    @Internal
    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<DynamoDbWriteRequest>> createWriter(Sink.InitContext context) throws IOException {
        return this.restoreWriter(context, Collections.emptyList());
    }

    @Internal
    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<DynamoDbWriteRequest>> restoreWriter(Sink.InitContext context, Collection<BufferedRequestState<DynamoDbWriteRequest>> recoveredState) throws IOException {
        return new DynamoDbSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.tableName, this.overwriteByPartitionKeys, new DynamoDbAsyncClientProvider(this.dynamoDbClientProperties), recoveredState);
    }

    @Internal
    public SimpleVersionedSerializer<BufferedRequestState<DynamoDbWriteRequest>> getWriterStateSerializer() {
        return new DynamoDbWriterStateSerializer();
    }
}

