/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.dynamodb.sink;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequest;
import org.apache.flink.connector.dynamodb.sink.DynamoDbWriteRequestType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.BeanTableSchema;

@PublicEvolving
public class DynamoDbBeanElementConverter<InputT>
implements ElementConverter<InputT, DynamoDbWriteRequest> {
    private static final long serialVersionUID = 1L;
    private final Class<InputT> recordType;
    private final boolean ignoreNulls;
    private transient BeanTableSchema<InputT> tableSchema;

    public DynamoDbBeanElementConverter(Class<InputT> recordType) {
        this(recordType, false);
    }

    public DynamoDbBeanElementConverter(Class<InputT> recordType, boolean ignoreNulls) {
        this.recordType = recordType;
        this.ignoreNulls = ignoreNulls;
        this.createTableSchema(recordType);
    }

    public DynamoDbWriteRequest apply(InputT element, SinkWriter.Context context) {
        if (this.tableSchema == null) {
            this.tableSchema = this.createTableSchema(this.recordType);
        }
        return new DynamoDbWriteRequest.Builder().setType(DynamoDbWriteRequestType.PUT).setItem(this.tableSchema.itemToMap(element, this.ignoreNulls)).build();
    }

    private BeanTableSchema<InputT> createTableSchema(Class<InputT> recordType) {
        return BeanTableSchema.create(recordType);
    }
}

