/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.offset;

import io.debezium.connector.db2.Lsn;
import java.util.Map;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.db2.source.offset.LsnOffset;

public class LsnFactory
extends OffsetFactory {
    private static final String EVENT_SERIAL_NO_KEY = "event_serial_no";

    public Offset newOffset(Map<String, String> offset) {
        Lsn changeLsn = Lsn.valueOf((String)offset.get("change_lsn"));
        Lsn commitLsn = Lsn.valueOf((String)offset.get("commit_lsn"));
        Long eventSerialNo = null;
        if (offset.get(EVENT_SERIAL_NO_KEY) != null) {
            eventSerialNo = Long.valueOf(offset.get(EVENT_SERIAL_NO_KEY));
        }
        return new LsnOffset(changeLsn, commitLsn, eventSerialNo);
    }

    public Offset newOffset(String filename, Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by filename and position.");
    }

    public Offset newOffset(Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by filename and position.");
    }

    public Offset createTimestampOffset(long timestampMillis) {
        throw new UnsupportedOperationException("not supported create new Offset by timestamp.");
    }

    public Offset createInitialOffset() {
        return LsnOffset.INITIAL_OFFSET;
    }

    public Offset createNoStoppingOffset() {
        return LsnOffset.NO_STOPPING_OFFSET;
    }
}

