/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.table;

import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.cdc.connectors.base.options.JdbcSourceOptions;
import org.apache.flink.cdc.connectors.base.options.SourceOptions;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.db2.table.Db2TableSource;
import org.apache.flink.cdc.connectors.db2.table.Db2TableSourceFactory;
import org.apache.flink.cdc.debezium.utils.ResolvedSchemaUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class Db2TableSourceFactoryTest {
    private static final ResolvedSchema SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"aaa", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"bbb", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"ccc", (DataType)DataTypes.DOUBLE()), Column.physical((String)"ddd", (DataType)DataTypes.DECIMAL((int)31, (int)18)), Column.physical((String)"eee", (DataType)DataTypes.TIMESTAMP((int)3))), new ArrayList(), UniqueConstraint.primaryKey((String)"pk", Arrays.asList("bbb", "aaa")));
    private static final ResolvedSchema SCHEMA_WITH_METADATA = new ResolvedSchema(Arrays.asList(Column.physical((String)"aaa", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"bbb", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"ccc", (DataType)DataTypes.DOUBLE()), Column.physical((String)"ddd", (DataType)DataTypes.DECIMAL((int)31, (int)18)), Column.physical((String)"eee", (DataType)DataTypes.TIMESTAMP((int)3)), Column.metadata((String)"database_name", (DataType)DataTypes.STRING(), (String)"database_name", (boolean)true), Column.metadata((String)"table_name", (DataType)DataTypes.STRING(), (String)"table_name", (boolean)true), Column.metadata((String)"schema_name", (DataType)DataTypes.STRING(), (String)"schema_name", (boolean)true), Column.metadata((String)"time", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), (String)"op_ts", (boolean)true)), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", Arrays.asList("bbb", "aaa")));
    private static final String MY_LOCALHOST = "localhost";
    private static final String MY_USERNAME = "flinkuser";
    private static final String MY_PASSWORD = "flinkpw";
    private static final String MY_DATABASE = "myDB";
    private static final String MY_TABLE = "flinkuser.myTable";
    private static final Properties PROPERTIES = new Properties();

    @Test
    public void testCommonProperties() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = Db2TableSourceFactoryTest.createTableSource(properties, SCHEMA);
        Db2TableSource expectedSource = new Db2TableSource(ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)SCHEMA), 50000, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.of("UTC"), PROPERTIES, StartupOptions.initial(), ((Boolean)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED.defaultValue()).booleanValue(), ((Integer)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)JdbcSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)JdbcSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)JdbcSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)JdbcSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)JdbcSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), null, false, ((Boolean)JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testOptionalProperties() {
        Map<String, String> options = this.getAllOptions();
        options.put("port", "50000");
        options.put("server-time-zone", "Asia/Shanghai");
        options.put("debezium.snapshot.mode", "schema_only");
        DynamicTableSource actualSource = Db2TableSourceFactoryTest.createTableSource(options, SCHEMA);
        Properties dbzProperties = new Properties();
        dbzProperties.put("snapshot.mode", "schema_only");
        Db2TableSource expectedSource = new Db2TableSource(ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)SCHEMA), 50000, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.of("Asia/Shanghai"), dbzProperties, StartupOptions.latest(), ((Boolean)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED.defaultValue()).booleanValue(), ((Integer)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)JdbcSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)JdbcSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)JdbcSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)JdbcSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)JdbcSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), null, false, ((Boolean)JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testValidation() {
        try {
            Map<String, String> properties = this.getAllOptions();
            properties.put("port", "123b");
            Db2TableSourceFactoryTest.createTableSource(properties, SCHEMA);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"Could not parse value '123b' for key 'port'.").isPresent());
        }
        Db2TableSourceFactory factory = new Db2TableSourceFactory();
        for (ConfigOption requiredOption : factory.requiredOptions()) {
            Map<String, String> properties = this.getAllOptions();
            properties.remove(requiredOption.key());
            try {
                Db2TableSourceFactoryTest.createTableSource(properties, SCHEMA);
                Assert.fail((String)"exception expected");
            }
            catch (Throwable t) {
                Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)("Missing required options are:\n\n" + requiredOption.key())).isPresent());
            }
        }
        try {
            Map<String, String> properties = this.getAllOptions();
            properties.put("unknown", "abc");
            Db2TableSourceFactoryTest.createTableSource(properties, SCHEMA);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"Unsupported options:\n\nunknown").isPresent());
        }
    }

    @Test
    public void testMetadataColumns() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = Db2TableSourceFactoryTest.createTableSource(properties, SCHEMA_WITH_METADATA);
        Db2TableSource db2TableSource = (Db2TableSource)actualSource;
        db2TableSource.applyReadableMetadata(Arrays.asList("op_ts", "database_name", "table_name", "schema_name"), SCHEMA_WITH_METADATA.toSourceRowDataType());
        actualSource = db2TableSource.copy();
        Db2TableSource expectedSource = new Db2TableSource(SCHEMA_WITH_METADATA, 50000, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.of("UTC"), new Properties(), StartupOptions.initial(), ((Boolean)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED.defaultValue()).booleanValue(), ((Integer)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)JdbcSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)JdbcSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)JdbcSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)JdbcSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)JdbcSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), null, false, ((Boolean)JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        expectedSource.producedDataType = SCHEMA_WITH_METADATA.toSourceRowDataType();
        expectedSource.metadataKeys = Arrays.asList("op_ts", "database_name", "table_name", "schema_name");
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    private Map<String, String> getAllOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "db2-cdc");
        options.put("hostname", MY_LOCALHOST);
        options.put("database-name", MY_DATABASE);
        options.put("table-name", MY_TABLE);
        options.put("username", MY_USERNAME);
        options.put("password", MY_PASSWORD);
        return options;
    }

    private static DynamicTableSource createTableSource(Map<String, String> options, ResolvedSchema schema) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"default", (String)"default", (String)"t1"), (ResolvedCatalogTable)new ResolvedCatalogTable(CatalogTable.of((Schema)TableSchema.fromResolvedSchema((ResolvedSchema)schema).toSchema(), (String)"mock source", new ArrayList(), options), schema), (ReadableConfig)new Configuration(), (ClassLoader)Db2TableSourceFactoryTest.class.getClassLoader(), (boolean)false);
    }
}

