/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.awaitility.Awaitility;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public class Db2TestBase {
    private static final Logger LOG = LoggerFactory.getLogger(Db2TestBase.class);
    private static final DockerImageName DEBEZIUM_DOCKER_IMAGE_NAME = DockerImageName.parse((String)((String)new ImageFromDockerfile("custom/db2-cdc:1.4").withDockerfile(Db2TestBase.getFilePath("db2_server/Dockerfile")).get())).asCompatibleSubstituteFor("ibmcom/db2");
    private static boolean db2AsnAgentRunning = false;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)--.*$");
    protected static final Db2Container DB2_CONTAINER = (Db2Container)((Db2Container)((Db2Container)((Db2Container)new Db2Container(DEBEZIUM_DOCKER_IMAGE_NAME).withDatabaseName("testdb").withUsername("db2inst1").withPassword("flinkpw").withEnv("AUTOCONFIG", "false")).withEnv("ARCHIVE_LOGS", "true")).acceptLicense().withLogConsumer((Consumer)new Slf4jLogConsumer(LOG))).withLogConsumer(outputFrame -> {
        if (outputFrame.getUtf8String().contains("The asncdc program enable finished")) {
            db2AsnAgentRunning = true;
        }
    });

    @BeforeClass
    public static void startContainers() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(DB2_CONTAINER)).join();
        LOG.info("Containers are started.");
        LOG.info("Waiting db2 asn agent start...");
        while (!db2AsnAgentRunning) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("unexpected interrupted exception", (Throwable)e);
            }
        }
        LOG.info("Db2 asn agent are started.");
    }

    @AfterClass
    public static void stopContainers() {
        LOG.info("Stopping containers...");
        if (DB2_CONTAINER != null) {
            DB2_CONTAINER.stop();
        }
        LOG.info("Containers are stopped.");
    }

    protected Connection getJdbcConnection() throws SQLException {
        return DriverManager.getConnection(DB2_CONTAINER.getJdbcUrl(), DB2_CONTAINER.getUsername(), DB2_CONTAINER.getPassword());
    }

    private static Path getFilePath(String resourceFilePath) {
        Path path = null;
        try {
            URL filePath = Db2TestBase.class.getClassLoader().getResource(resourceFilePath);
            Assert.assertNotNull((String)("Cannot locate " + resourceFilePath), (Object)filePath);
            path = Paths.get(filePath.toURI());
        }
        catch (URISyntaxException e) {
            LOG.error("Cannot get path from URI.", (Throwable)e);
        }
        return path;
    }

    private static void dropTestTable(Connection connection, String tableName) {
        try {
            Awaitility.await((String)String.format("cdc remove table %s", tableName)).atMost(30L, TimeUnit.SECONDS).until(() -> {
                try {
                    String removeSql = String.format("CALL ASNCDC.REMOVETABLE('DB2INST1', '%s')", tableName);
                    connection.createStatement().execute(removeSql);
                    String reinitSql = String.format("VALUES ASNCDC.ASNCDCSERVICES('reinit','asncdc');", tableName);
                    connection.createStatement().execute(reinitSql);
                    return true;
                }
                catch (SQLException e) {
                    LOG.warn(String.format("cdc remove TABLE %s failed (will be retried): {}", tableName), (Object)e.getMessage());
                    return false;
                }
            });
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to remove cdc table " + tableName, (Throwable)e);
        }
        try {
            Awaitility.await((String)String.format("Dropping table %s", tableName)).atMost(30L, TimeUnit.SECONDS).until(() -> {
                try {
                    String sql = String.format("DROP TABLE DB2INST1.%s", tableName);
                    connection.createStatement().execute(sql);
                    connection.commit();
                    return true;
                }
                catch (SQLException e) {
                    LOG.warn(String.format("DROP TABLE %s failed (will be retried): {}", tableName), (Object)e.getMessage());
                    return false;
                }
            });
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to drop table", (Throwable)e);
        }
    }

    private static boolean checkTableExists(Connection connection, String tableName) {
        AtomicBoolean tableExists = new AtomicBoolean(false);
        try {
            Awaitility.await((String)String.format("check table %s exists or not", tableName)).atMost(30L, TimeUnit.SECONDS).until(() -> {
                try {
                    String tableExistSql = String.format("SELECT COUNT(*) FROM SYSCAT.TABLES WHERE TABNAME = '%s' AND TABSCHEMA = 'DB2INST1';", tableName);
                    ResultSet resultSet = connection.createStatement().executeQuery(tableExistSql);
                    if (resultSet.next() && resultSet.getInt(1) == 1) {
                        tableExists.set(true);
                    }
                    return true;
                }
                catch (SQLException e) {
                    LOG.warn(String.format("check table %s exists failed", tableName), (Object)e.getMessage());
                    return false;
                }
            });
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to check table " + tableName + " exists", (Throwable)e);
        }
        return tableExists.get();
    }

    protected void initializeDb2Table(String sqlFile, String tableName) {
        String ddlFile = String.format("db2_server/%s.sql", sqlFile);
        URL ddlTestFile = Db2TestBase.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try (Connection connection = this.getJdbcConnection();
             Statement statement = connection.createStatement();){
            if (Db2TestBase.checkTableExists(connection, tableName)) {
                LOG.info("{} table exist", (Object)tableName);
                Db2TestBase.dropTestTable(connection, tableName.toUpperCase(Locale.ROOT));
                Thread.sleep(10000L);
            }
            List statements = Arrays.stream(Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream().map(String::trim).filter(x -> !x.startsWith("--") && !x.isEmpty()).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).collect(Collectors.joining("\n")).split(";")).collect(Collectors.toList());
            for (String stmt : statements) {
                statement.execute(stmt);
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertEqualsInAnyOrder(List<String> expected, List<String> actual) {
        Assert.assertTrue((expected != null && actual != null ? 1 : 0) != 0);
        Db2TestBase.assertEqualsInOrder(expected.stream().sorted().collect(Collectors.toList()), actual.stream().sorted().collect(Collectors.toList()));
    }

    public static void assertEqualsInOrder(List<String> expected, List<String> actual) {
        Assert.assertTrue((expected != null && actual != null ? 1 : 0) != 0);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertArrayEquals((Object[])expected.toArray(new String[0]), (Object[])actual.toArray(new String[0]));
    }

    public void executeSql(String sql) {
        try (Connection connection = this.getJdbcConnection();){
            connection.createStatement().execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTableNameRegex(String[] captureCustomerTables) {
        Preconditions.checkState((captureCustomerTables.length > 0 ? 1 : 0) != 0);
        if (captureCustomerTables.length == 1) {
            return captureCustomerTables[0];
        }
        return String.format("(%s)", StringUtils.join((Object[])captureCustomerTables, (String)","));
    }
}

