/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2;

import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.db2.Db2TestBase;
import org.apache.flink.cdc.connectors.db2.source.Db2SourceBuilder;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.JsonDebeziumDeserializationSchema;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.junit.Ignore;
import org.junit.Test;

public class Db2ParallelSourceExampleTest
extends Db2TestBase {
    @Test
    @Ignore(value="Test ignored because it won't stop and is used for manual test")
    public void testDb2ExampleSource() throws Exception {
        this.initializeDb2Table("customers", "CUSTOMERS");
        Db2SourceBuilder.Db2IncrementalSource sqlServerSource = new Db2SourceBuilder().hostname(DB2_CONTAINER.getHost()).port(DB2_CONTAINER.getMappedPort(50000).intValue()).databaseList(new String[]{DB2_CONTAINER.getDatabaseName()}).tableList(new String[]{"DB2INST1.CUSTOMERS"}).username(DB2_CONTAINER.getUsername()).password(DB2_CONTAINER.getPassword()).deserializer((DebeziumDeserializationSchema)new JsonDebeziumDeserializationSchema()).startupOptions(StartupOptions.initial()).build();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(3000L);
        env.fromSource((Source)sqlServerSource, WatermarkStrategy.noWatermarks(), "Db2IncrementalSource").setParallelism(2).print().setParallelism(1);
        env.execute("Print DB2 Snapshot + Change Stream");
    }
}

