/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.connector.sink2.StatefulSinkWriter;
import org.apache.flink.api.connector.sink2.WriterInitContext;
import org.apache.flink.connector.base.sink.ArrayListDestination;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriter;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriterStateSerializer;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.base.sink.writer.ResultHandler;
import org.apache.flink.connector.base.sink.writer.config.AsyncSinkWriterConfiguration;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class ArrayListAsyncSink
extends AsyncSinkBase<String, Integer> {
    public ArrayListAsyncSink() {
        this(25, 1, 100, 100000L, 1000L, 100000L);
    }

    public ArrayListAsyncSink(int maxBatchSize, int maxInFlightRequests, int maxBufferedRequests, long maxBatchSizeInBytes, long maxTimeInBufferMS, long maxRecordSizeInBytes) {
        super((ElementConverter & Serializable)(element, x) -> Integer.parseInt(element), maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBatchSizeInBytes, maxTimeInBufferMS, maxRecordSizeInBytes);
    }

    public StatefulSinkWriter<String, BufferedRequestState<Integer>> createWriter(WriterInitContext context) throws IOException {
        return new AsyncSinkWriter<String, Integer>(this.getElementConverter(), context, AsyncSinkWriterConfiguration.builder().setMaxBatchSize(this.getMaxBatchSize()).setMaxBatchSizeInBytes(this.getMaxBatchSizeInBytes()).setMaxInFlightRequests(this.getMaxInFlightRequests()).setMaxBufferedRequests(this.getMaxBufferedRequests()).setMaxTimeInBufferMS(this.getMaxTimeInBufferMS()).setMaxRecordSizeInBytes(this.getMaxRecordSizeInBytes()).build(), Collections.emptyList()){

            protected void submitRequestEntries(List<Integer> requestEntries, ResultHandler<Integer> resultHandler) {
                try {
                    ArrayListDestination.putRecords(requestEntries);
                }
                catch (RuntimeException e) {
                    this.getFatalExceptionCons().accept(e);
                }
                resultHandler.complete();
            }

            protected long getSizeInBytes(Integer requestEntry) {
                return 4L;
            }
        };
    }

    public StatefulSinkWriter<String, BufferedRequestState<Integer>> restoreWriter(WriterInitContext context, Collection<BufferedRequestState<Integer>> recoveredState) throws IOException {
        return this.createWriter(context);
    }

    public SimpleVersionedSerializer<BufferedRequestState<Integer>> getWriterStateSerializer() {
        return new AsyncSinkWriterStateSerializer<Integer>(){

            protected void serializeRequestToStream(Integer request, DataOutputStream out) throws IOException {
                out.writeInt(request);
            }

            protected Integer deserializeRequestFromStream(long requestSize, DataInputStream in) throws IOException {
                return in.readInt();
            }

            public int getVersion() {
                return 0;
            }
        };
    }
}

