/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer.strategy;

import org.apache.flink.connector.base.sink.writer.strategy.AIMDScalingStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AIMDScalingStrategyTest {
    AIMDScalingStrategyTest() {
    }

    @Test
    void testScaleUpAdditively() {
        int increaseRate = 10;
        int currentRate = 4;
        AIMDScalingStrategy scalingStrategy = AIMDScalingStrategy.builder((int)1000).setIncreaseRate(10).setDecreaseFactor(0.5).build();
        Assertions.assertThat((Integer)scalingStrategy.scaleUp(Integer.valueOf(4))).isEqualTo(14);
    }

    @Test
    void testScaleUpRespectsRateThreshold() {
        int increaseRate = 10;
        int currentRate = 14;
        int rateThreshold = 20;
        AIMDScalingStrategy scalingStrategy = AIMDScalingStrategy.builder((int)20).setIncreaseRate(10).setDecreaseFactor(0.5).build();
        Assertions.assertThat((Integer)scalingStrategy.scaleUp(Integer.valueOf(24))).isEqualTo(20);
    }

    @Test
    void testScaleDownByFactor() {
        double decreaseFactor = 0.4;
        AIMDScalingStrategy scalingStrategy = AIMDScalingStrategy.builder((int)1000).setIncreaseRate(10).setDecreaseFactor(0.4).build();
        Assertions.assertThat((Integer)scalingStrategy.scaleDown(Integer.valueOf(10))).isEqualTo(4);
        Assertions.assertThat((Integer)scalingStrategy.scaleDown(Integer.valueOf(314))).isEqualTo(126);
    }

    @Test
    void testScaleDownByFactorStopsAtOne() {
        double decreaseFactor = 0.1;
        AIMDScalingStrategy scalingStrategy = AIMDScalingStrategy.builder((int)1000).setIncreaseRate(10).setDecreaseFactor(0.1).build();
        Assertions.assertThat((Integer)scalingStrategy.scaleDown(Integer.valueOf(1))).isEqualTo(1);
    }

    @Test
    void testInvalidIncreaseRate() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> AIMDScalingStrategy.builder((int)100).setIncreaseRate(0).setDecreaseFactor(0.5).build()).withMessageContaining("increaseRate must be positive integer.");
    }

    @Test
    void testInvalidDecreaseFactor() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> AIMDScalingStrategy.builder((int)100).setIncreaseRate(1).setDecreaseFactor(0.0).build()).withMessageContaining("decreaseFactor must be strictly between 0.0 and 1.0.");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> AIMDScalingStrategy.builder((int)100).setIncreaseRate(1).setDecreaseFactor(1.0).build()).withMessageContaining("decreaseFactor must be strictly between 0.0 and 1.0.");
    }

    @Test
    void testInvalidRateThreshold() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> AIMDScalingStrategy.builder((int)0).setIncreaseRate(1).setDecreaseFactor(0.5).build()).withMessageContaining("rateThreshold must be a positive integer.");
    }
}

