/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.metrics.testutils.MetricListener;
import org.apache.flink.runtime.metrics.groups.InternalSinkWriterMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorImpl;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailboxImpl;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingRunnable;

public class TestSinkInitContext
implements Sink.InitContext {
    private static final TestProcessingTimeService processingTimeService = new TestProcessingTimeService();
    private final MetricListener metricListener = new MetricListener();
    private final OperatorIOMetricGroup operatorIOMetricGroup = UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup().getIOMetricGroup();
    private final SinkWriterMetricGroup metricGroup = InternalSinkWriterMetricGroup.mock((MetricGroup)this.metricListener.getMetricGroup(), (OperatorIOMetricGroup)this.operatorIOMetricGroup);
    private final MailboxExecutor mailboxExecutor;
    StreamTaskActionExecutor streamTaskActionExecutor = new StreamTaskActionExecutor(){

        public void run(RunnableWithException e) throws Exception {
            e.run();
        }

        public <E extends Throwable> void runThrowing(ThrowingRunnable<E> throwingRunnable) throws E {
            throwingRunnable.run();
        }

        public <R> R call(Callable<R> callable) throws Exception {
            return callable.call();
        }
    };

    public TestSinkInitContext() {
        this.mailboxExecutor = new MailboxExecutorImpl((TaskMailbox)new TaskMailboxImpl(Thread.currentThread()), Integer.MAX_VALUE, this.streamTaskActionExecutor);
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return null;
    }

    public MailboxExecutor getMailboxExecutor() {
        return this.mailboxExecutor;
    }

    public ProcessingTimeService getProcessingTimeService() {
        return new ProcessingTimeService(){

            public long getCurrentProcessingTime() {
                return processingTimeService.getCurrentProcessingTime();
            }

            public ScheduledFuture<?> registerTimer(long time, ProcessingTimeService.ProcessingTimeCallback processingTimerCallback) {
                processingTimeService.registerTimer(time, arg_0 -> ((ProcessingTimeService.ProcessingTimeCallback)processingTimerCallback).onProcessingTime(arg_0));
                return null;
            }
        };
    }

    public int getSubtaskId() {
        return 0;
    }

    public int getNumberOfParallelSubtasks() {
        return 0;
    }

    public int getAttemptNumber() {
        return 0;
    }

    public SinkWriterMetricGroup metricGroup() {
        return this.metricGroup;
    }

    public OptionalLong getRestoredCheckpointId() {
        return OptionalLong.empty();
    }

    public SerializationSchema.InitializationContext asSerializationSchemaInitializationContext() {
        return null;
    }

    public TestProcessingTimeService getTestProcessingTimeService() {
        return processingTimeService;
    }

    public Optional<Gauge<Long>> getCurrentSendTimeGauge() {
        return this.metricListener.getGauge(new String[]{"currentSendTime"});
    }

    public Counter getNumRecordsOutCounter() {
        return this.metricGroup.getIOMetricGroup().getNumRecordsOutCounter();
    }

    public Counter getNumBytesOutCounter() {
        return this.metricGroup.getIOMetricGroup().getNumBytesOutCounter();
    }
}

