/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.serialization;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.kinesis.source.serialization.KinesisDeserializationSchema;
import org.apache.flink.util.Collector;
import software.amazon.awssdk.services.kinesis.model.Record;

@Internal
class KinesisDeserializationSchemaWrapper<T>
implements KinesisDeserializationSchema<T> {
    private static final long serialVersionUID = 9143148962928375886L;
    private final DeserializationSchema<T> deserializationSchema;

    KinesisDeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    @Override
    public void deserialize(Record record, String stream, String shardId, Collector<T> output) throws IOException {
        this.deserializationSchema.deserialize(record.data().asByteArray(), output);
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

