/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.kinesis.source.KinesisStreamsSource;
import org.apache.flink.connector.kinesis.source.enumerator.KinesisShardAssigner;
import org.apache.flink.connector.kinesis.source.enumerator.assigner.ShardAssignerFactory;
import org.apache.flink.connector.kinesis.source.serialization.KinesisDeserializationSchema;

@Experimental
public class KinesisStreamsSourceBuilder<T> {
    private String streamArn;
    private Configuration sourceConfig;
    private KinesisDeserializationSchema<T> deserializationSchema;
    private KinesisShardAssigner kinesisShardAssigner = ShardAssignerFactory.uniformShardAssigner();

    public KinesisStreamsSourceBuilder<T> setStreamArn(String streamArn) {
        this.streamArn = streamArn;
        return this;
    }

    public KinesisStreamsSourceBuilder<T> setSourceConfig(Configuration sourceConfig) {
        this.sourceConfig = sourceConfig;
        return this;
    }

    public KinesisStreamsSourceBuilder<T> setDeserializationSchema(KinesisDeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
        return this;
    }

    public KinesisStreamsSourceBuilder<T> setDeserializationSchema(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = KinesisDeserializationSchema.of(deserializationSchema);
        return this;
    }

    public KinesisStreamsSourceBuilder<T> setKinesisShardAssigner(KinesisShardAssigner kinesisShardAssigner) {
        this.kinesisShardAssigner = kinesisShardAssigner;
        return this;
    }

    public KinesisStreamsSource<T> build() {
        return new KinesisStreamsSource<T>(this.streamArn, this.sourceConfig, this.deserializationSchema, this.kinesisShardAssigner);
    }
}

