/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.split;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@Internal
public final class StartingPosition {
    private final ShardIteratorType shardIteratorType;
    private final Object startingMarker;

    StartingPosition(ShardIteratorType shardIteratorType, Object startingMarker) {
        this.shardIteratorType = shardIteratorType;
        this.startingMarker = startingMarker;
    }

    public ShardIteratorType getShardIteratorType() {
        return this.shardIteratorType;
    }

    @Nullable
    public Object getStartingMarker() {
        return this.startingMarker;
    }

    public static StartingPosition fromTimestamp(Instant timestamp) {
        return new StartingPosition(ShardIteratorType.AT_TIMESTAMP, timestamp);
    }

    public static StartingPosition continueFromSequenceNumber(String sequenceNumber) {
        return new StartingPosition(ShardIteratorType.AFTER_SEQUENCE_NUMBER, sequenceNumber);
    }

    public static StartingPosition fromStart() {
        return new StartingPosition(ShardIteratorType.TRIM_HORIZON, null);
    }

    public String toString() {
        return "StartingPosition{shardIteratorType=" + this.shardIteratorType + ", startingMarker=" + this.startingMarker + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartingPosition that = (StartingPosition)o;
        return this.shardIteratorType == that.shardIteratorType && Objects.equals(this.startingMarker, that.startingMarker);
    }

    public int hashCode() {
        return Objects.hash(this.shardIteratorType, this.startingMarker);
    }
}

