/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.enumerator.assigner;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kinesis.source.enumerator.KinesisShardAssigner;
import org.apache.flink.connector.kinesis.source.split.KinesisShardSplit;
import org.apache.flink.util.Preconditions;

@Internal
public class UniformShardAssigner
implements KinesisShardAssigner {
    @Override
    public int assign(KinesisShardSplit split, KinesisShardAssigner.Context context) {
        int selectedSubtask = -1;
        int curMinAssignment = Integer.MAX_VALUE;
        Map<Integer, Set<KinesisShardSplit>> splitAssignment = context.getCurrentSplitAssignment();
        Map<Integer, List<KinesisShardSplit>> pendingSplitAssignments = context.getPendingSplitAssignments();
        for (int subtaskId : context.getRegisteredReaders().keySet()) {
            int subtaskAssignmentSize = splitAssignment.getOrDefault(subtaskId, Collections.emptySet()).size() + pendingSplitAssignments.getOrDefault(subtaskId, Collections.emptyList()).size();
            if (subtaskAssignmentSize >= curMinAssignment) continue;
            curMinAssignment = subtaskAssignmentSize;
            selectedSubtask = subtaskId;
        }
        Preconditions.checkArgument((selectedSubtask != -1 ? 1 : 0) != 0, (Object)"Expected at least one registered reader. Unable to assign split.");
        return selectedSubtask;
    }
}

