/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.config;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.kinesis.source.config.KinesisStreamsSourceConfigConstants;
import org.apache.flink.util.Preconditions;

@Internal
public class KinesisStreamsSourceConfigUtil {
    private KinesisStreamsSourceConfigUtil() {
    }

    public static Date parseStreamTimestampStartingPosition(Configuration sourceConfig) {
        Preconditions.checkNotNull((Object)sourceConfig);
        String timestamp = (String)sourceConfig.get(KinesisStreamsSourceConfigConstants.STREAM_INITIAL_TIMESTAMP);
        try {
            String format = (String)sourceConfig.get(KinesisStreamsSourceConfigConstants.STREAM_TIMESTAMP_DATE_FORMAT);
            SimpleDateFormat customDateFormat = new SimpleDateFormat(format);
            return customDateFormat.parse(timestamp);
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (ParseException exception) {
            return new Date((long)(Double.parseDouble(timestamp) * 1000.0));
        }
    }
}

