/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.table;

import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.table.AsyncDynamicTableSinkFactory;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.connector.kinesis.table.KinesisConnectorOptions;
import org.apache.flink.connector.kinesis.table.KinesisDynamicSink;
import org.apache.flink.connector.kinesis.table.util.KinesisStreamsConnectorOptionsUtils;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class KinesisDynamicTableSinkFactory
extends AsyncDynamicTableSinkFactory {
    public static final String IDENTIFIER = "kinesis";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        AsyncDynamicTableSinkFactory.AsyncDynamicSinkContext factoryContext = new AsyncDynamicTableSinkFactory.AsyncDynamicSinkContext((AsyncDynamicTableSinkFactory)this, (AsyncDynamicTableSinkFactory)this, context);
        KinesisStreamsConnectorOptionsUtils optionsUtils = new KinesisStreamsConnectorOptionsUtils(factoryContext.getResolvedOptions(), factoryContext.getTableOptions(), (RowType)factoryContext.getPhysicalDataType().getLogicalType(), factoryContext.getPartitionKeys(), context.getClassLoader());
        factoryContext.getFactoryHelper().validateExcept(optionsUtils.getNonValidatedPrefixes().toArray(new String[0]));
        KinesisDynamicTableSinkFactory.validateKinesisPartitioner(factoryContext.getTableOptions(), factoryContext.isPartitioned());
        Properties properties = optionsUtils.getValidatedSinkConfigurations();
        KinesisDynamicSink.KinesisDynamicTableSinkBuilder builder = new KinesisDynamicSink.KinesisDynamicTableSinkBuilder();
        builder.setStream((String)properties.get(KinesisConnectorOptions.STREAM.key())).setKinesisClientProperties((Properties)properties.get("sink.client.properties")).setEncodingFormat((EncodingFormat<SerializationSchema<RowData>>)factoryContext.getEncodingFormat()).setConsumedDataType(factoryContext.getPhysicalDataType()).setPartitioner((PartitionKeyGenerator)properties.get(KinesisConnectorOptions.SINK_PARTITIONER.key()));
        this.addAsyncOptionsToBuilder(properties, builder);
        Optional.ofNullable((Boolean)properties.get(KinesisConnectorOptions.SINK_FAIL_ON_ERROR.key())).ifPresent(builder::setFailOnError);
        return builder.build();
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KinesisConnectorOptions.STREAM);
        options.add(FactoryUtil.FORMAT);
        options.add(KinesisConnectorOptions.AWS_REGION);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        Set options = super.optionalOptions();
        options.add(KinesisConnectorOptions.SINK_PARTITIONER);
        options.add(KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER);
        options.add(KinesisConnectorOptions.SINK_FAIL_ON_ERROR);
        return KinesisStreamsConnectorOptionsUtils.KinesisProducerOptionsMapper.addDeprecatedKeys(options);
    }

    private static void validateKinesisPartitioner(ReadableConfig tableOptions, boolean isPartitioned) {
        tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER).ifPresent(partitioner -> {
            if (isPartitioned) {
                throw new ValidationException(String.format("Cannot set %s option for a table defined with a PARTITIONED BY clause", KinesisConnectorOptions.SINK_PARTITIONER.key()));
            }
        });
    }
}

