/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.table;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.connector.base.table.AsyncSinkConnectorOptions;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;

@PublicEvolving
public class KinesisConnectorOptions
extends AsyncSinkConnectorOptions {
    public static final ConfigOption<String> STREAM = ConfigOptions.key((String)"stream").stringType().noDefaultValue().withDescription("Name of the Kinesis stream backing this table.");
    public static final ConfigOption<String> AWS_REGION = ConfigOptions.key((String)"aws.region").stringType().noDefaultValue().withDescription("AWS region of used Kinesis stream.");
    public static final ConfigOption<String> SHARD_ASSIGNER = ConfigOptions.key((String)"scan.shard-assigner").stringType().defaultValue((Object)"default").withDescription("Shard assigner to use when mapping shards to Flink subtasks.");
    public static final ConfigOption<String> SINK_PARTITIONER = ConfigOptions.key((String)"sink.partitioner").stringType().noDefaultValue().withDescription(Description.builder().text("Optional output partitioning from Flink's partitions into Kinesis shards. Sinks that write to tables defined with the %s clause always use a field-based partitioner and cannot define this option.", new InlineElement[]{TextElement.code((String)"PARTITION BY")}).linebreak().text("Valid enumerations are").list(new InlineElement[]{TextElement.text((String)"random (use a random partition key)"), TextElement.text((String)"fixed (each Flink partition ends up in at most one Kinesis shard)"), TextElement.text((String)"custom class name (use a custom %s subclass)", (InlineElement[])new InlineElement[]{TextElement.text((String)PartitionKeyGenerator.class.getName())})}).build());
    public static final ConfigOption<String> SINK_PARTITIONER_FIELD_DELIMITER = ConfigOptions.key((String)"sink.partitioner-field-delimiter").stringType().defaultValue((Object)"|").withDescription(Description.builder().text("Optional field delimiter for fields-based partitioner derived from a %s clause", new InlineElement[]{TextElement.code((String)"PARTITION BY")}).build());
    public static final ConfigOption<Boolean> SINK_FAIL_ON_ERROR = ConfigOptions.key((String)"sink.fail-on-error").booleanType().defaultValue((Object)false).withDescription("Determines whether an exception should fail the job, otherwise failed requests are retried.");
}

