/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.split;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Instant;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kinesis.source.split.KinesisShardSplit;
import org.apache.flink.connector.kinesis.source.split.StartingPosition;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.io.VersionMismatchException;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@Internal
public class KinesisShardSplitSerializer
implements SimpleVersionedSerializer<KinesisShardSplit> {
    private static final int CURRENT_VERSION = 0;

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(KinesisShardSplit split) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeUTF(split.getStreamArn());
                out.writeUTF(split.getShardId());
                out.writeUTF(split.getStartingPosition().getShardIteratorType().toString());
                if (split.getStartingPosition().getStartingMarker() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    Object startingMarker = split.getStartingPosition().getStartingMarker();
                    out.writeBoolean(startingMarker instanceof Instant);
                    if (startingMarker instanceof Instant) {
                        out.writeLong(((Instant)startingMarker).toEpochMilli());
                    }
                    out.writeBoolean(startingMarker instanceof String);
                    if (startingMarker instanceof String) {
                        out.writeUTF((String)startingMarker);
                    }
                }
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public KinesisShardSplit deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            KinesisShardSplit kinesisShardSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                if (version != this.getVersion()) {
                    throw new VersionMismatchException("Trying to deserialize KinesisShardSplit serialized with unsupported version " + version + ". Version of serializer is " + this.getVersion());
                }
                String streamArn = in.readUTF();
                String shardId = in.readUTF();
                ShardIteratorType shardIteratorType = ShardIteratorType.fromValue((String)in.readUTF());
                Object startingMarker = null;
                boolean hasStartingMarker = in.readBoolean();
                if (hasStartingMarker) {
                    if (in.readBoolean()) {
                        startingMarker = Instant.ofEpochMilli(in.readLong());
                    }
                    if (in.readBoolean()) {
                        startingMarker = in.readUTF();
                    }
                }
                kinesisShardSplit = new KinesisShardSplit(streamArn, shardId, new StartingPosition(shardIteratorType, startingMarker));
            }
            return kinesisShardSplit;
        }
    }
}

