/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.split;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.kinesis.source.split.StartingPosition;
import org.apache.flink.util.Preconditions;

@Internal
public final class KinesisShardSplit
implements SourceSplit {
    private final String streamArn;
    private final String shardId;
    private final StartingPosition startingPosition;

    public KinesisShardSplit(String streamArn, String shardId, StartingPosition startingPosition) {
        Preconditions.checkNotNull((Object)streamArn, (String)"streamArn cannot be null");
        Preconditions.checkNotNull((Object)shardId, (String)"shardId cannot be null");
        Preconditions.checkNotNull((Object)startingPosition, (String)"startingPosition cannot be null");
        this.streamArn = streamArn;
        this.shardId = shardId;
        this.startingPosition = startingPosition;
    }

    public String splitId() {
        return this.shardId;
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public String getShardId() {
        return this.shardId;
    }

    public StartingPosition getStartingPosition() {
        return this.startingPosition;
    }

    public String toString() {
        return "KinesisShardSplit{streamArn='" + this.streamArn + '\'' + ", shardId='" + this.shardId + '\'' + ", startingPosition=" + this.startingPosition + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinesisShardSplit that = (KinesisShardSplit)o;
        return Objects.equals(this.streamArn, that.streamArn) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.startingPosition, that.startingPosition);
    }

    public int hashCode() {
        return Objects.hash(this.streamArn, this.shardId, this.startingPosition);
    }
}

