/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.enumerator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kinesis.source.enumerator.KinesisStreamsSourceEnumeratorState;
import org.apache.flink.connector.kinesis.source.split.KinesisShardSplit;
import org.apache.flink.connector.kinesis.source.split.KinesisShardSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.io.VersionMismatchException;

@Internal
public class KinesisStreamsSourceEnumeratorStateSerializer
implements SimpleVersionedSerializer<KinesisStreamsSourceEnumeratorState> {
    private static final int CURRENT_VERSION = 0;
    private final KinesisShardSplitSerializer splitSerializer;

    public KinesisStreamsSourceEnumeratorStateSerializer(KinesisShardSplitSerializer splitSerializer) {
        this.splitSerializer = splitSerializer;
    }

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(KinesisStreamsSourceEnumeratorState kinesisStreamsSourceEnumeratorState) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                boolean hasLastSeenShardId = kinesisStreamsSourceEnumeratorState.getLastSeenShardId() != null;
                out.writeBoolean(hasLastSeenShardId);
                if (hasLastSeenShardId) {
                    out.writeUTF(kinesisStreamsSourceEnumeratorState.getLastSeenShardId());
                }
                out.writeInt(kinesisStreamsSourceEnumeratorState.getUnassignedSplits().size());
                out.writeInt(this.splitSerializer.getVersion());
                for (KinesisShardSplit split : kinesisStreamsSourceEnumeratorState.getUnassignedSplits()) {
                    byte[] serializedSplit = this.splitSerializer.serialize(split);
                    out.writeInt(serializedSplit.length);
                    out.write(serializedSplit);
                }
                out.flush();
                object = baos.toByteArray();
            }
            return object;
        }
    }

    public KinesisStreamsSourceEnumeratorState deserialize(int version, byte[] serializedEnumeratorState) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serializedEnumeratorState);){
            KinesisStreamsSourceEnumeratorState kinesisStreamsSourceEnumeratorState;
            try (DataInputStream in = new DataInputStream(bais);){
                if (version != this.getVersion()) {
                    throw new VersionMismatchException("Trying to deserialize KinesisStreamsSourceEnumeratorState serialized with unsupported version " + version + ". Serializer version is " + this.getVersion());
                }
                String lastSeenShardId = null;
                boolean hasLastSeenShardId = in.readBoolean();
                if (hasLastSeenShardId) {
                    lastSeenShardId = in.readUTF();
                }
                int numUnassignedSplits = in.readInt();
                int splitSerializerVersion = in.readInt();
                if (splitSerializerVersion != this.splitSerializer.getVersion()) {
                    throw new VersionMismatchException("Trying to deserialize KinesisShardSplit serialized with unsupported version " + splitSerializerVersion + ". Serializer version is " + this.splitSerializer.getVersion());
                }
                HashSet<KinesisShardSplit> unassignedSplits = new HashSet<KinesisShardSplit>(numUnassignedSplits);
                for (int i = 0; i < numUnassignedSplits; ++i) {
                    int serializedLength = in.readInt();
                    byte[] serializedSplit = new byte[serializedLength];
                    if (in.read(serializedSplit) == -1) {
                        throw new IOException("Unexpectedly reading more bytes than is present in stream.");
                    }
                    unassignedSplits.add(this.splitSerializer.deserialize(splitSerializerVersion, serializedSplit));
                }
                if (in.available() > 0) {
                    throw new IOException("Unexpected trailing bytes when deserializing.");
                }
                kinesisStreamsSourceEnumeratorState = new KinesisStreamsSourceEnumeratorState(unassignedSplits, lastSeenShardId);
            }
            return kinesisStreamsSourceEnumeratorState;
        }
    }
}

