/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.config;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@Experimental
public class KinesisStreamsSourceConfigConstants {
    public static final ConfigOption<InitialPosition> STREAM_INITIAL_POSITION = ConfigOptions.key((String)"flink.stream.initpos").enumType(InitialPosition.class).defaultValue((Object)InitialPosition.LATEST).withDescription("The initial position to start reading Kinesis streams.");
    public static final ConfigOption<String> STREAM_INITIAL_TIMESTAMP = ConfigOptions.key((String)"flink.stream.initpos.timestamp").stringType().noDefaultValue().withDescription("The initial timestamp at which to start reading from the Kinesis stream. This is used when AT_TIMESTAMP is configured for the STREAM_INITIAL_POSITION.");
    public static final ConfigOption<String> STREAM_TIMESTAMP_DATE_FORMAT = ConfigOptions.key((String)"flink.stream.initpos.timestamp.format").stringType().defaultValue((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withDescription("The date format used to parse the initial timestamp at which to start reading from the Kinesis stream. This is used when AT_TIMESTAMP is configured for the STREAM_INITIAL_POSITION.");
    public static final ConfigOption<Long> SHARD_DISCOVERY_INTERVAL_MILLIS = ConfigOptions.key((String)"flink.shard.discovery.intervalmillis").longType().defaultValue((Object)10000L).withDescription("The interval between each attempt to discover new shards.");

    public static enum InitialPosition {
        LATEST,
        TRIM_HORIZON,
        AT_TIMESTAMP;

    }
}

