/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.table;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.connector.kinesis.table.FixedKinesisPartitionKeyGenerator;
import org.apache.flink.connector.kinesis.table.KinesisConnectorOptions;
import org.apache.flink.connector.kinesis.table.RandomKinesisPartitionKeyGenerator;
import org.apache.flink.connector.kinesis.table.RowDataFieldsKinesisPartitionKeyGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class KinesisPartitionKeyGeneratorFactory {
    public static final String SINK_PARTITIONER_VALUE_FIXED = "fixed";
    public static final String SINK_PARTITIONER_VALUE_RANDOM = "random";

    public static PartitionKeyGenerator<RowData> getKinesisPartitioner(ReadableConfig tableOptions, RowType physicalType, List<String> partitionKeys, ClassLoader classLoader) {
        if (!partitionKeys.isEmpty()) {
            String delimiter = (String)tableOptions.get(KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER);
            return new RowDataFieldsKinesisPartitionKeyGenerator(physicalType, partitionKeys, delimiter);
        }
        if (!tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER).isPresent()) {
            return new RandomKinesisPartitionKeyGenerator<RowData>();
        }
        String partitioner = (String)tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER).get();
        if (SINK_PARTITIONER_VALUE_FIXED.equals(partitioner)) {
            return new FixedKinesisPartitionKeyGenerator<RowData>();
        }
        if (SINK_PARTITIONER_VALUE_RANDOM.equals(partitioner)) {
            return new RandomKinesisPartitionKeyGenerator<RowData>();
        }
        return KinesisPartitionKeyGeneratorFactory.initializePartitioner(partitioner, classLoader);
    }

    private static <T> PartitionKeyGenerator<T> initializePartitioner(String name, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(name, true, classLoader);
            if (!PartitionKeyGenerator.class.isAssignableFrom(clazz)) {
                throw new ValidationException(String.format("Partitioner class '%s' should have %s in its parents chain", name, PartitionKeyGenerator.class.getName()));
            }
            PartitionKeyGenerator partitioner = (PartitionKeyGenerator)InstantiationUtil.instantiate((String)name, PartitionKeyGenerator.class, (ClassLoader)classLoader);
            return partitioner;
        }
        catch (ClassNotFoundException | FlinkException e) {
            throw new ValidationException(String.format("Could not find and instantiate partitioner class '%s'", name), e);
        }
    }
}

