/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.table.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.aws.table.util.AsyncClientOptionsUtils;
import org.apache.flink.connector.base.table.sink.options.AsyncSinkConfigurationValidator;
import org.apache.flink.connector.firehose.table.KinesisFirehoseConnectorOptions;

@Internal
public class KinesisFirehoseConnectorOptionUtils {
    public static final String FIREHOSE_CLIENT_PROPERTIES_KEY = "sink.client.properties";
    private final AsyncSinkConfigurationValidator asyncSinkConfigurationValidator;
    private final AsyncClientOptionsUtils asyncClientOptionsUtils;
    private final Map<String, String> resolvedOptions;
    private final ReadableConfig tableOptions;

    public KinesisFirehoseConnectorOptionUtils(Map<String, String> resolvedOptions, ReadableConfig tableOptions) {
        this.asyncSinkConfigurationValidator = new AsyncSinkConfigurationValidator(tableOptions);
        this.asyncClientOptionsUtils = new AsyncClientOptionsUtils(resolvedOptions);
        this.resolvedOptions = resolvedOptions;
        this.tableOptions = tableOptions;
    }

    public List<String> getNonValidatedPrefixes() {
        return this.asyncClientOptionsUtils.getNonValidatedPrefixes();
    }

    public Properties getSinkProperties() {
        Properties properties = this.asyncSinkConfigurationValidator.getValidatedConfigurations();
        properties.put(KinesisFirehoseConnectorOptions.DELIVERY_STREAM.key(), this.tableOptions.get(KinesisFirehoseConnectorOptions.DELIVERY_STREAM));
        Properties kinesisClientProps = this.asyncClientOptionsUtils.getValidatedConfigurations();
        properties.put(FIREHOSE_CLIENT_PROPERTIES_KEY, kinesisClientProps);
        if (this.tableOptions.getOptional(KinesisFirehoseConnectorOptions.SINK_FAIL_ON_ERROR).isPresent()) {
            properties.put(KinesisFirehoseConnectorOptions.SINK_FAIL_ON_ERROR.key(), this.tableOptions.getOptional(KinesisFirehoseConnectorOptions.SINK_FAIL_ON_ERROR).get());
        }
        return properties;
    }
}

