/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.table;

import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.connector.base.table.AsyncDynamicTableSinkFactory;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.connector.firehose.table.KinesisFirehoseConnectorOptions;
import org.apache.flink.connector.firehose.table.KinesisFirehoseDynamicSink;
import org.apache.flink.connector.firehose.table.util.KinesisFirehoseConnectorOptionUtils;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;

@Internal
public class KinesisFirehoseDynamicTableFactory
extends AsyncDynamicTableSinkFactory {
    public static final String IDENTIFIER = "firehose";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        AsyncDynamicTableSinkFactory.AsyncDynamicSinkContext factoryContext = new AsyncDynamicTableSinkFactory.AsyncDynamicSinkContext((AsyncDynamicTableSinkFactory)this, (AsyncDynamicTableSinkFactory)this, context);
        KinesisFirehoseDynamicSink.KinesisFirehoseDynamicSinkBuilder builder = new KinesisFirehoseDynamicSink.KinesisFirehoseDynamicSinkBuilder();
        KinesisFirehoseConnectorOptionUtils optionsUtils = new KinesisFirehoseConnectorOptionUtils(factoryContext.getResolvedOptions(), factoryContext.getTableOptions());
        factoryContext.getFactoryHelper().validateExcept(optionsUtils.getNonValidatedPrefixes().toArray(new String[0]));
        Properties properties = optionsUtils.getSinkProperties();
        builder.setDeliveryStream((String)properties.get(KinesisFirehoseConnectorOptions.DELIVERY_STREAM.key())).setFirehoseClientProperties((Properties)properties.get("sink.client.properties")).setEncodingFormat((EncodingFormat<SerializationSchema<RowData>>)factoryContext.getEncodingFormat()).setConsumedDataType(factoryContext.getPhysicalDataType());
        Optional.ofNullable((Boolean)properties.get(KinesisFirehoseConnectorOptions.SINK_FAIL_ON_ERROR.key())).ifPresent(builder::setFailOnError);
        return super.addAsyncOptionsToBuilder(properties, (AsyncDynamicTableSinkBuilder)builder).build();
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KinesisFirehoseConnectorOptions.DELIVERY_STREAM);
        options.add(FactoryUtil.FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        Set options = super.optionalOptions();
        options.add(KinesisFirehoseConnectorOptions.SINK_FAIL_ON_ERROR);
        return options;
    }
}

