/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.table;

import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseSink;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseSinkBuilder;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import software.amazon.awssdk.services.firehose.model.Record;

@Internal
public class KinesisFirehoseDynamicSink
extends AsyncDynamicTableSink<Record> {
    private final DataType consumedDataType;
    private final String deliveryStream;
    private final Properties firehoseClientProperties;
    private final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    private final Boolean failOnError;

    protected KinesisFirehoseDynamicSink(@Nullable Integer maxBatchSize, @Nullable Integer maxInFlightRequests, @Nullable Integer maxBufferedRequests, @Nullable Long maxBufferSizeInBytes, @Nullable Long maxTimeInBufferMS, @Nullable Boolean failOnError, @Nullable DataType consumedDataType, String deliveryStream, @Nullable Properties firehoseClientProperties, EncodingFormat<SerializationSchema<RowData>> encodingFormat) {
        super(maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBufferSizeInBytes, maxTimeInBufferMS);
        this.failOnError = failOnError;
        this.firehoseClientProperties = firehoseClientProperties;
        this.consumedDataType = (DataType)Preconditions.checkNotNull((Object)consumedDataType, (String)"Consumed data type must not be null");
        this.deliveryStream = (String)Preconditions.checkNotNull((Object)deliveryStream, (String)"Firehose Delivery stream name must not be null");
        this.encodingFormat = (EncodingFormat)Preconditions.checkNotNull(encodingFormat, (String)"Encoding format must not be null");
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.encodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.consumedDataType);
        KinesisFirehoseSinkBuilder builder = KinesisFirehoseSink.builder().setSerializationSchema(serializationSchema).setFirehoseClientProperties(this.firehoseClientProperties).setDeliveryStreamName(this.deliveryStream);
        Optional.ofNullable(this.failOnError).ifPresent(builder::setFailOnError);
        super.addAsyncOptionsToSinkBuilder(builder);
        return SinkV2Provider.of((Sink)builder.build());
    }

    public DynamicTableSink copy() {
        return new KinesisFirehoseDynamicSink(this.maxBatchSize, this.maxInFlightRequests, this.maxBufferedRequests, this.maxBufferSizeInBytes, this.maxTimeInBufferMS, this.failOnError, this.consumedDataType, this.deliveryStream, this.firehoseClientProperties, this.encodingFormat);
    }

    public String asSummaryString() {
        return "firehose";
    }

    @Internal
    public static class KinesisFirehoseDynamicSinkBuilder
    extends AsyncDynamicTableSinkBuilder<Record, KinesisFirehoseDynamicSinkBuilder> {
        private DataType consumedDataType = null;
        private String deliveryStream = null;
        private Properties firehoseClientProperties = null;
        private EncodingFormat<SerializationSchema<RowData>> encodingFormat = null;
        private Boolean failOnError = null;

        public KinesisFirehoseDynamicSinkBuilder setConsumedDataType(DataType consumedDataType) {
            this.consumedDataType = consumedDataType;
            return this;
        }

        public KinesisFirehoseDynamicSinkBuilder setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        public KinesisFirehoseDynamicSinkBuilder setFirehoseClientProperties(Properties firehoseClientProperties) {
            this.firehoseClientProperties = firehoseClientProperties;
            return this;
        }

        public KinesisFirehoseDynamicSinkBuilder setEncodingFormat(EncodingFormat<SerializationSchema<RowData>> encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public KinesisFirehoseDynamicSinkBuilder setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public KinesisFirehoseDynamicSink build() {
            return new KinesisFirehoseDynamicSink(this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBufferSizeInBytes(), this.getMaxTimeInBufferMS(), this.failOnError, this.consumedDataType, this.deliveryStream, this.firehoseClientProperties, this.encodingFormat);
        }
    }
}

