/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.sink;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriterStateSerializer;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.firehose.model.Record;

@Internal
public class KinesisFirehoseStateSerializer
extends AsyncSinkWriterStateSerializer<Record> {
    protected void serializeRequestToStream(Record request, DataOutputStream out) throws IOException {
        out.write(request.data().asByteArrayUnsafe());
    }

    protected Record deserializeRequestFromStream(long requestSize, DataInputStream in) throws IOException {
        byte[] requestData = new byte[(int)requestSize];
        in.read(requestData);
        return (Record)Record.builder().data(SdkBytes.fromByteArray((byte[])requestData)).build();
    }

    public int getVersion() {
        return 1;
    }
}

