/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.firehose.model.Record;

@Internal
public class KinesisFirehoseSinkElementConverter<InputT>
implements ElementConverter<InputT, Record> {
    private boolean schemaOpened = false;
    private final SerializationSchema<InputT> serializationSchema;

    private KinesisFirehoseSinkElementConverter(SerializationSchema<InputT> serializationSchema) {
        this.serializationSchema = serializationSchema;
    }

    public Record apply(InputT element, SinkWriter.Context context) {
        this.checkOpened();
        return (Record)Record.builder().data(SdkBytes.fromByteArray((byte[])this.serializationSchema.serialize(element))).build();
    }

    private void checkOpened() {
        if (!this.schemaOpened) {
            try {
                this.serializationSchema.open(new SerializationSchema.InitializationContext(){

                    public MetricGroup getMetricGroup() {
                        return new UnregisteredMetricsGroup();
                    }

                    public UserCodeClassLoader getUserCodeClassLoader() {
                        return SimpleUserCodeClassLoader.create((ClassLoader)KinesisFirehoseSinkElementConverter.class.getClassLoader());
                    }
                });
                this.schemaOpened = true;
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to initialize serialization schema.", (Throwable)e);
            }
        }
    }

    public static <InputT> Builder<InputT> builder() {
        return new Builder();
    }

    public static class Builder<InputT> {
        private SerializationSchema<InputT> serializationSchema;

        public Builder<InputT> setSerializationSchema(SerializationSchema<InputT> serializationSchema) {
            this.serializationSchema = serializationSchema;
            return this;
        }

        public KinesisFirehoseSinkElementConverter<InputT> build() {
            Preconditions.checkNotNull(this.serializationSchema, (String)"No SerializationSchema was supplied to the KinesisFirehoseSink builder.");
            return new KinesisFirehoseSinkElementConverter(this.serializationSchema);
        }
    }
}

